/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.PrivateKey;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;

public class SECPPrivateKey
implements PrivateKey {
    private final Bytes32 encoded;
    private final String algorithm;

    private SECPPrivateKey(Bytes32 encoded, String algorithm) {
        Preconditions.checkNotNull((Object)encoded);
        Preconditions.checkNotNull((Object)algorithm);
        this.encoded = encoded;
        this.algorithm = algorithm;
    }

    public static SECPPrivateKey create(BigInteger key, String algorithm) {
        Preconditions.checkNotNull((Object)key);
        return SECPPrivateKey.create((Bytes32)UInt256.valueOf((BigInteger)key), algorithm);
    }

    public static SECPPrivateKey create(Bytes32 key, String algorithm) {
        return new SECPPrivateKey(key, algorithm);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SECPPrivateKey)) {
            return false;
        }
        SECPPrivateKey that = (SECPPrivateKey)other;
        return this.encoded.equals(that.encoded) && this.algorithm.equals(that.algorithm);
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded.toArrayUnsafe();
    }

    public Bytes32 getEncodedBytes() {
        return this.encoded;
    }

    public BigInteger getD() {
        return this.encoded.toUnsignedBigInteger();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public String toString() {
        return this.encoded.toString();
    }
}

