/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import com.swirlds.fchashmap.FCHashMap;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class FCHashMapEntrySetIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final FCHashMap<K, V> map;
    private final Iterator<K> keyIterator;
    private K nextValidKey;
    private K previousValidKey;

    public FCHashMapEntrySetIterator(FCHashMap<K, V> map, Iterator<K> keyIterator) {
        this.map = map;
        this.keyIterator = keyIterator;
    }

    private void advanceIterator() {
        if (this.nextValidKey != null) {
            return;
        }
        while (this.keyIterator.hasNext()) {
            K nextKey = this.keyIterator.next();
            if (!this.map.containsKey(nextKey)) continue;
            this.nextValidKey = nextKey;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.advanceIterator();
        return this.nextValidKey != null;
    }

    @Override
    public Map.Entry<K, V> next() {
        this.advanceIterator();
        if (this.nextValidKey != null) {
            this.previousValidKey = this.nextValidKey;
            this.nextValidKey = null;
            return new AbstractMap.SimpleEntry<K, V>(this.previousValidKey, this.map.get(this.previousValidKey));
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.previousValidKey == null) {
            throw new IllegalStateException();
        }
        this.map.remove(this.previousValidKey);
        this.previousValidKey = null;
    }
}

