/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl;

import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableTopicStoreImpl
implements ReadableTopicStore {
    private final ReadableKVState<TopicID, Topic> topicState;
    private final ReadableEntityCounters entityCounters;

    public ReadableTopicStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.topicState = states.get("TOPICS");
    }

    @Nullable
    public Topic getTopic(@NonNull TopicID id) {
        Objects.requireNonNull(id);
        return (Topic)this.topicState.get((Object)id);
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.TOPIC);
    }

    protected <T extends ReadableKVState<TopicID, Topic>> T topicState() {
        return (T)this.topicState;
    }
}

