/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers.customfee;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConsensusCustomFeeAssessor {
    @Inject
    public ConsensusCustomFeeAssessor() {
    }

    public Map<FixedCustomFee, CryptoTransferTransactionBody> assessCustomFee(@NonNull List<FixedCustomFee> customFees, @NonNull AccountID payer) {
        HashMap<FixedCustomFee, CryptoTransferTransactionBody> transactionBodies = new HashMap<FixedCustomFee, CryptoTransferTransactionBody>();
        for (FixedCustomFee fee : customFees) {
            ArrayList<TokenTransferList> tokenTransfers = new ArrayList<TokenTransferList>();
            TransferList.Builder hbarTransfers = TransferList.newBuilder();
            FixedFee fixedFee = fee.fixedFeeOrThrow();
            if (fixedFee.hasDenominatingTokenId()) {
                tokenTransfers.add(this.buildCustomFeeTokenTransferList(payer, fee.feeCollectorAccountId(), fixedFee));
            } else {
                List<AccountAmount> accountAmounts = this.buildCustomFeeHbarTransferList(payer, fee.feeCollectorAccountId(), fixedFee);
                hbarTransfers.accountAmounts((AccountAmount[])accountAmounts.toArray(AccountAmount[]::new));
            }
            CryptoTransferTransactionBody.Builder syntheticBodyBuilder = CryptoTransferTransactionBody.newBuilder().transfers(hbarTransfers.build()).tokenTransfers(tokenTransfers);
            transactionBodies.put(fee, syntheticBodyBuilder.build());
        }
        return transactionBodies;
    }

    private List<AccountAmount> buildCustomFeeHbarTransferList(AccountID payer, AccountID collector, FixedFee fee) {
        return List.of(AccountAmount.newBuilder().accountID(payer).amount(-fee.amount()).build(), AccountAmount.newBuilder().accountID(collector).amount(fee.amount()).build());
    }

    private TokenTransferList buildCustomFeeTokenTransferList(AccountID payer, AccountID collector, FixedFee fee) {
        return TokenTransferList.newBuilder().token(fee.denominatingTokenId()).transfers(new AccountAmount[]{AccountAmount.newBuilder().accountID(payer).amount(-fee.amount()).build(), AccountAmount.newBuilder().accountID(collector).amount(fee.amount()).build()}).build();
    }

    @VisibleForTesting
    public AccountID getTokenTreasury(TokenID tokenId, ReadableTokenStore tokenStore) {
        Token token = TokenHandlerHelper.getIfUsable((TokenID)tokenId, (ReadableTokenStore)tokenStore, (TokenHandlerHelper.TokenValidations)TokenHandlerHelper.TokenValidations.REQUIRE_NOT_PAUSED, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES);
        return token.treasuryAccountIdOrThrow();
    }
}

