/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hederaaccountnumalias;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hederaaccountnumalias.HederaAccountNumAliasTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class HederaAccountNumAliasCall
extends AbstractCall {
    private final Address address;

    public HederaAccountNumAliasCall(@NonNull HasCallAttempt attempt, @NonNull Address address) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.address = Objects.requireNonNull(address);
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        long accountNum = ConversionUtils.accountNumberForEvmReference(this.address, this.nativeOperations());
        if (accountNum < 0L) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, true);
        }
        Account account = this.enhancement.nativeOperations().getAccount(this.nativeOperations().entityIdFactory().newAccountId(accountNum));
        if (account == null) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, true);
        }
        Objects.requireNonNull(account.accountId());
        if (!account.accountIdOrElse(AccountID.DEFAULT).hasAccountNum()) {
            return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, ReturnTypes.ZERO_ADDRESS), ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS, true);
        }
        Address accountAsAddress = ConversionUtils.asHeadlongAddress(ConversionUtils.asEvmAddress(account.accountIdOrElse(AccountID.DEFAULT).accountNumOrElse(Long.valueOf(0L))));
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, accountAsAddress), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    private FullResult fullResultsFor(ResponseCodeEnum responseCode, Address address) {
        return FullResult.successResult(HederaAccountNumAliasTranslator.HEDERA_ACCOUNT_NUM_ALIAS.getOutputs().encode((Object)Tuple.of((Object)responseCode.protoOrdinal(), (Object)address)), this.gasCalculator.viewGasRequirement());
    }
}

