/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isvalidalias;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isvalidalias.IsValidAliasTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class IsValidAliasCall
extends AbstractCall {
    private final Address address;

    public IsValidAliasCall(@NonNull HasCallAttempt attempt, @NonNull Address address) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.address = Objects.requireNonNull(address);
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        AliasKind aliasKind = IsValidAliasCall.getAliasKindForAddressWithAccount(this.address, this.nativeOperations());
        boolean isValidAlias = aliasKind != AliasKind.EVM_ADDRESS_WITH_NO_ASSOCIATED_ACCOUNT;
        return Call.PricedResult.gasOnly(this.fullResultsFor(isValidAlias), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    public static AliasKind getAliasKindForAddressWithAccount(@NonNull Address address, @NonNull HederaNativeOperations nativeOperations) {
        boolean isAccountNumAlias = ConversionUtils.isLongZero(address);
        long accountNum = ConversionUtils.accountNumberForEvmReference(address, nativeOperations);
        if (accountNum == -1L) {
            return AliasKind.EVM_ADDRESS_WITH_NO_ASSOCIATED_ACCOUNT;
        }
        if (accountNum == -2L) {
            return AliasKind.ACCOUNT_NUM_ALIAS_OF_ACCOUNT_WITHOUT_EVM_ALIAS;
        }
        return isAccountNumAlias ? AliasKind.ACCOUNT_NUM_ALIAS_OF_ACCOUNT_WITH_EVM_ALIAS : AliasKind.EVM_ALIAS_OF_ACCOUNT;
    }

    @NonNull
    private FullResult fullResultsFor(boolean result) {
        return FullResult.successResult(IsValidAliasTranslator.IS_VALID_ALIAS.getOutputs().encode((Object)Tuple.singleton((Object)result)), this.gasCalculator.viewGasRequirement());
    }

    public static enum AliasKind {
        ACCOUNT_NUM_ALIAS_OF_ACCOUNT_WITH_EVM_ALIAS,
        ACCOUNT_NUM_ALIAS_OF_ACCOUNT_WITHOUT_EVM_ALIAS,
        EVM_ALIAS_OF_ACCOUNT,
        EVM_ADDRESS_WITH_NO_ASSOCIATED_ACCOUNT;

    }
}

