/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.getscheduledinfo;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.getscheduledinfo.GetScheduledInfoTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.TokenTupleUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class GetScheduledNonFungibleTokenCreateCall
extends AbstractCall {
    private final ScheduleID scheduleID;
    private final Configuration configuration;

    public GetScheduledNonFungibleTokenCreateCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull Configuration configuration, @NonNull ScheduleID scheduleID) {
        super(gasCalculator, enhancement, true);
        this.configuration = configuration;
        this.scheduleID = scheduleID;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        Schedule schedule = this.nativeOperations().getSchedule(this.scheduleID);
        if (schedule == null) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.RECORD_NOT_FOUND, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.RECORD_NOT_FOUND, this.isViewCall);
        }
        if (schedule.scheduledTransaction() == null || schedule.scheduledTransaction().tokenCreation() == null) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_SCHEDULE_ID, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_SCHEDULE_ID, this.isViewCall);
        }
        TokenCreateTransactionBody tokenCreation = schedule.scheduledTransaction().tokenCreation();
        if (tokenCreation.tokenType() == TokenType.FUNGIBLE_COMMON) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_SCHEDULE_ID, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_SCHEDULE_ID, this.isViewCall);
        }
        LedgerConfig ledgerConfig = (LedgerConfig)this.configuration.getConfigData(LedgerConfig.class);
        String ledgerId = Bytes.wrap((byte[])ledgerConfig.id().toByteArray()).toString();
        return Call.PricedResult.gasOnly(FullResult.successResult(GetScheduledInfoTranslator.GET_SCHEDULED_CREATE_NON_FUNGIBLE_TOKEN_INFO.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)TokenTupleUtils.nftTokenInfoTupleFor(tokenCreation, ledgerId, 1))), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, this.isViewCall);
    }
}

