/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.CryptoDeleteAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.token.NftRemoveAllowance;
import com.hedera.hapi.node.token.TokenAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public abstract class AbstractGrantApprovalCall
extends AbstractCall {
    protected final VerificationStrategy verificationStrategy;
    protected final AccountID senderId;
    protected final TokenID tokenId;
    protected final AccountID spenderId;
    protected final TokenType tokenType;
    protected final long amount;

    protected AbstractGrantApprovalCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID senderId, @NonNull TokenID tokenId, @NonNull AccountID spenderId, long amount, @NonNull TokenType tokenType, boolean isViewCall) {
        super(gasCalculator, enhancement, isViewCall);
        this.verificationStrategy = verificationStrategy;
        this.senderId = senderId;
        this.tokenId = tokenId;
        this.spenderId = spenderId;
        this.amount = amount;
        this.tokenType = tokenType;
    }

    protected ContractCallStreamBuilder withMonoStandard(@NonNull ContractCallStreamBuilder recordBuilder) {
        if (recordBuilder.status() == ResponseCodeEnum.DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL || recordBuilder.status() == ResponseCodeEnum.INVALID_SIGNATURE) {
            recordBuilder.status(ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
        }
        return recordBuilder;
    }

    protected TransactionBody synthApprovalBody() {
        if (this.tokenType == TokenType.NON_FUNGIBLE_UNIQUE) {
            AccountID ownerId = this.getMaybeOwnerId();
            if (ownerId != null && !this.isNftApprovalRevocation() && !ownerId.equals((Object)this.senderId)) {
                return this.buildCryptoApproveAllowance(this.approveDelegate(ownerId, this.senderId));
            }
            return this.isNftApprovalRevocation() ? this.buildCryptoDeleteAllowance(this.remove(ownerId)) : this.buildCryptoApproveAllowance(this.approve(ownerId));
        }
        return this.buildCryptoApproveAllowance(this.approve(this.senderId));
    }

    private CryptoDeleteAllowanceTransactionBody remove(AccountID ownerId) {
        return CryptoDeleteAllowanceTransactionBody.newBuilder().nftAllowances(new NftRemoveAllowance[]{NftRemoveAllowance.newBuilder().tokenId(this.tokenId).owner(ownerId).serialNumbers(new Long[]{this.amount}).build()}).build();
    }

    private CryptoApproveAllowanceTransactionBody approveDelegate(AccountID ownerId, AccountID delegateSpenderId) {
        return CryptoApproveAllowanceTransactionBody.newBuilder().nftAllowances(new NftAllowance[]{NftAllowance.newBuilder().tokenId(this.tokenId).spender(this.spenderId).delegatingSpender(delegateSpenderId).owner(ownerId).serialNumbers(new Long[]{this.amount}).build()}).build();
    }

    private CryptoApproveAllowanceTransactionBody approve(AccountID ownerId) {
        return this.tokenType.equals((Object)TokenType.FUNGIBLE_COMMON) ? CryptoApproveAllowanceTransactionBody.newBuilder().tokenAllowances(new TokenAllowance[]{TokenAllowance.newBuilder().tokenId(this.tokenId).spender(this.spenderId).owner(ownerId).amount(this.amount).build()}).build() : CryptoApproveAllowanceTransactionBody.newBuilder().nftAllowances(new NftAllowance[]{NftAllowance.newBuilder().tokenId(this.tokenId).spender(this.spenderId).owner(ownerId).serialNumbers(new Long[]{this.amount}).build()}).build();
    }

    private TransactionBody buildCryptoDeleteAllowance(CryptoDeleteAllowanceTransactionBody body) {
        return TransactionBody.newBuilder().cryptoDeleteAllowance(body).build();
    }

    private TransactionBody buildCryptoApproveAllowance(CryptoApproveAllowanceTransactionBody body) {
        return TransactionBody.newBuilder().cryptoApproveAllowance(body).build();
    }

    @Nullable
    protected AccountID getMaybeOwnerId() {
        Nft nft = this.enhancement.nativeOperations().getNft(this.tokenId, this.amount);
        if (nft == null) {
            return null;
        }
        if (nft.hasOwnerId()) {
            return nft.ownerId();
        }
        Token token = this.nativeOperations().getToken(this.tokenId);
        return token == null ? null : token.treasuryAccountIdOrThrow();
    }

    private boolean isNftApprovalRevocation() {
        return this.spenderId.accountNumOrElse(Long.valueOf(0L)) == 0L;
    }
}

