/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenexpiry;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNonRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.TokenTupleUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenexpiry.TokenExpiryTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class TokenExpiryCall
extends AbstractNonRevertibleTokenViewCall {
    private final boolean isStaticCall;

    public TokenExpiryCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token) {
        super(gasCalculator, enhancement, token);
        this.isStaticCall = isStaticCall;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, this.gasCalculator.viewGasRequirement(), token), ResponseCodeEnum.SUCCESS, true);
    }

    @Override
    @NonNull
    protected FullResult viewCallResultWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return this.fullResultsFor(status, gasRequirement, Token.DEFAULT);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, Token token) {
        if (this.isStaticCall && status != ResponseCodeEnum.SUCCESS) {
            return FullResult.revertResult(status, gasRequirement);
        }
        return FullResult.successResult(TokenExpiryTranslator.TOKEN_EXPIRY.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)TokenTupleUtils.expiryTupleFor(token))), gasRequirement);
    }
}

