/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.Erc721TransferFromCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Erc721TransferFromTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod ERC_721_TRANSFER_FROM = SystemContractMethod.declare("transferFrom(address,address,uint256)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.TRANSFER);

    @Inject
    public Erc721TransferFromTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(ERC_721_TRANSFER_FROM);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        if (!attempt.isRedirect()) {
            return Optional.empty();
        }
        if (attempt.redirectTokenType() != TokenType.NON_FUNGIBLE_UNIQUE) {
            return Optional.empty();
        }
        return attempt.isMethod(ERC_721_TRANSFER_FROM);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Tuple call = ERC_721_TRANSFER_FROM.decodeCall(attempt.input().toArrayUnsafe());
        return new Erc721TransferFromCall(((BigInteger)call.get(2)).longValueExact(), (Address)call.get(0), (Address)call.get(1), Objects.requireNonNull(attempt.redirectToken()).tokenIdOrThrow(), attempt.defaultVerificationStrategy(), attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.senderId(), attempt.addressIdConverter(), SpecialRewardReceivers.SPECIAL_REWARD_RECEIVERS);
    }
}

