/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.updatetokencustomfees;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenFeeScheduleUpdateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.updatetokencustomfees.UpdateTokenCustomFeesTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.function.TriFunction;

@Singleton
public class UpdateTokenCustomFeesDecoder {
    protected static final String UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_STRING = "updateFungibleTokenCustomFees(address,(int64,address,bool,bool,address)[],(int64,int64,int64,int64,bool,address)[])";
    protected static final String UPDATE_NON_FUNGIBLE_TOKEN_CUSTOM_FEES_STRING = "updateNonFungibleTokenCustomFees(address,(int64,address,bool,bool,address)[],(int64,int64,int64,address,bool,address)[])";
    private static final int TOKEN_ADDRESS = 0;
    private static final int FIXED_FEE = 1;
    private static final int FRACTIONAL_FEE = 2;
    private static final int ROYALTY_FEE = 2;
    private static final int FIXED_FEE_AMOUNT = 0;
    private static final int FIXED_FEE_TOKEN_ID = 1;
    private static final int FIXED_FEE_USE_HBARS_FOR_PAYMENT = 2;
    private static final int FIXED_FEE_USE_CURRENT_TOKEN_FOR_PAYMENT = 3;
    private static final int FIXED_FEE_FEE_COLLECTOR = 4;
    private static final int FRACTIONAL_FEE_NUMERATOR = 0;
    private static final int FRACTIONAL_FEE_DENOMINATOR = 1;
    private static final int FRACTIONAL_FEE_MIN_AMOUNT = 2;
    private static final int FRACTIONAL_FEE_MAX_AMOUNT = 3;
    private static final int FRACTIONAL_FEE_NET_OF_TRANSFERS = 4;
    private static final int FRACTIONAL_FEE_FEE_COLLECTOR = 5;
    private static final int ROYALTY_FEE_NUMERATOR = 0;
    private static final int ROYALTY_FEE_DENOMINATOR = 1;
    private static final int ROYALTY_FALLBACK_FEE_AMOUNT = 2;
    private static final int ROYALTY_FALLBACK_FEE_TOKEN_ID = 3;
    private static final int ROYALTY_FALLBACK_FEE_USE_HBARS_FOR_PAYMENT = 4;
    private static final int ROYALTY_FEE_FEE_COLLECTOR = 5;

    @Inject
    public UpdateTokenCustomFeesDecoder() {
    }

    public TransactionBody decodeUpdateFungibleTokenCustomFees(@NonNull HtsCallAttempt attempt) throws IllegalArgumentException {
        Tuple call = UpdateTokenCustomFeesTranslator.UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION.decodeCall(attempt.inputBytes());
        this.validateCustomFeesLength(attempt, call);
        return TransactionBody.newBuilder().tokenFeeScheduleUpdate(this.updateTokenCustomFees(call, attempt, (TriFunction<Tuple, HtsCallAttempt, TokenID, List<CustomFee>>)((TriFunction)this::customFungibleFees))).build();
    }

    public TransactionBody decodeUpdateNonFungibleTokenCustomFees(@NonNull HtsCallAttempt attempt) throws IllegalArgumentException {
        Tuple call = UpdateTokenCustomFeesTranslator.UPDATE_NON_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION.decodeCall(attempt.inputBytes());
        this.validateCustomFeesLength(attempt, call);
        return TransactionBody.newBuilder().tokenFeeScheduleUpdate(this.updateTokenCustomFees(call, attempt, (TriFunction<Tuple, HtsCallAttempt, TokenID, List<CustomFee>>)((TriFunction)this::customNonFungibleFees))).build();
    }

    private TokenFeeScheduleUpdateTransactionBody updateTokenCustomFees(@NonNull Tuple call, @NonNull HtsCallAttempt attempt, @NonNull TriFunction<Tuple, HtsCallAttempt, TokenID, List<CustomFee>> customFees) {
        Address tokenAddress = (Address)call.get(0);
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress);
        return TokenFeeScheduleUpdateTransactionBody.newBuilder().tokenId(tokenId).customFees((List)customFees.apply((Object)call, (Object)attempt, (Object)tokenId)).build();
    }

    private List<CustomFee> customFungibleFees(@NonNull Tuple call, @NonNull HtsCallAttempt attempt, @NonNull TokenID tokenId) {
        return Stream.concat(this.decodeFixedFees((Tuple[])call.get(1), attempt, tokenId), this.decodeFractionalFees((Tuple[])call.get(2), attempt)).toList();
    }

    private List<CustomFee> customNonFungibleFees(@NonNull Tuple call, @NonNull HtsCallAttempt attempt, @NonNull TokenID tokenId) {
        return Stream.concat(this.decodeFixedFees((Tuple[])call.get(1), attempt, tokenId), this.decodeRoyaltyFees((Tuple[])call.get(2), attempt)).toList();
    }

    private Stream<CustomFee> decodeFixedFees(@NonNull Tuple[] fixedFee, @NonNull HtsCallAttempt attempt, @NonNull TokenID tokenId) {
        return Arrays.stream(fixedFee).map(fee -> CustomFee.newBuilder().fixedFee(FixedFee.newBuilder().amount(((Long)fee.get(0)).longValue()).denominatingTokenId(this.determineDenominatingToken(attempt, (Tuple)fee, tokenId)).build()).feeCollectorAccountId(attempt.addressIdConverter().convert((Address)fee.get(4))).build());
    }

    private Stream<CustomFee> decodeFractionalFees(@NonNull Tuple[] fractionalFees, @NonNull HtsCallAttempt attempt) {
        return Arrays.stream(fractionalFees).map(fee -> CustomFee.newBuilder().fractionalFee(FractionalFee.newBuilder().fractionalAmount(Fraction.newBuilder().numerator(((Long)fee.get(0)).longValue()).denominator(((Long)fee.get(1)).longValue()).build()).minimumAmount(((Long)fee.get(2)).longValue()).maximumAmount(((Long)fee.get(3)).longValue()).netOfTransfers(((Boolean)fee.get(4)).booleanValue()).build()).feeCollectorAccountId(attempt.addressIdConverter().convert((Address)fee.get(5))).build());
    }

    private Stream<CustomFee> decodeRoyaltyFees(@NonNull Tuple[] royaltyFees, @NonNull HtsCallAttempt attempt) {
        return Arrays.stream(royaltyFees).map(fee -> CustomFee.newBuilder().royaltyFee(RoyaltyFee.newBuilder().exchangeValueFraction(Fraction.newBuilder().numerator(((Long)fee.get(0)).longValue()).denominator(((Long)fee.get(1)).longValue()).build()).fallbackFee(this.getFallbackFee(attempt, (Tuple)fee)).build()).feeCollectorAccountId(attempt.addressIdConverter().convert((Address)fee.get(5))).build());
    }

    private TokenID determineDenominatingToken(@NonNull HtsCallAttempt attempt, @NonNull Tuple fee, @NonNull TokenID tokenId) {
        boolean useCurrentToken = (Boolean)fee.get(3);
        return useCurrentToken ? tokenId : this.getDenominationTokenIdOrNull(attempt, (Address)fee.get(1), (Boolean)fee.get(2));
    }

    @Nullable
    private TokenID getDenominationTokenIdOrNull(@NonNull HtsCallAttempt attempt, @NonNull Address address, boolean useHbarsForPayment) {
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), address);
        return useHbarsForPayment || tokenId.equals((Object)TokenID.DEFAULT) ? null : tokenId;
    }

    @Nullable
    private FixedFee getFallbackFee(@NonNull HtsCallAttempt attempt, @NonNull Tuple fee) {
        Address tokenAddress = (Address)fee.get(3);
        long amount = (Long)fee.get(2);
        return ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress).equals((Object)TokenID.DEFAULT) && amount == 0L ? null : FixedFee.newBuilder().amount(amount).denominatingTokenId(this.getDenominationTokenIdOrNull(attempt, tokenAddress, (Boolean)fee.get(4))).build();
    }

    private void validateCustomFeesLength(@NonNull HtsCallAttempt attempt, @NonNull Tuple call) {
        int maxAllowedCustomFees = ((TokensConfig)attempt.configuration().getConfigData(TokensConfig.class)).maxCustomFeesAllowed();
        Tuple[] fixedFee = (Tuple[])call.get(1);
        Tuple[] fractionalOrRoyaltyFee = (Tuple[])call.get(2);
        HandleException.validateFalse((fixedFee.length > maxAllowedCustomFees ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
        HandleException.validateFalse((fractionalOrRoyaltyFee.length > maxAllowedCustomFees ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
        HandleException.validateFalse((fixedFee.length + fractionalOrRoyaltyFee.length > maxAllowedCustomFees ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
    }
}

