/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.config.data.OpsDurationConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;

public record OpsDurationSchedule(long[] opsDurationByOpCode, long opsGasBasedDurationMultiplier, long precompileGasBasedDurationMultiplier, long systemContractGasBasedDurationMultiplier, long accountLazyCreationOpsDurationMultiplier, long multipliersDenominator) {
    private static final long DEFAULT_MULTIPLIERS_DENOMINATOR = 100L;

    public static OpsDurationSchedule empty() {
        return new OpsDurationSchedule(new long[256], 0L, 0L, 0L, 0L, 1L);
    }

    public static OpsDurationSchedule fromConfig(@NonNull OpsDurationConfig opsDurationConfig) {
        long[] opsDurationByOpCodeArray = new long[256];
        opsDurationConfig.opsDurations1_to_64().forEach(opsDurationPair -> {
            opsDurationByOpCodeArray[opsDurationPair.left().intValue()] = opsDurationPair.right();
        });
        opsDurationConfig.opsDurations65_to_128().forEach(opsDurationPair -> {
            opsDurationByOpCodeArray[opsDurationPair.left().intValue()] = opsDurationPair.right();
        });
        opsDurationConfig.opsDurations129_to_192().forEach(opsDurationPair -> {
            opsDurationByOpCodeArray[opsDurationPair.left().intValue()] = opsDurationPair.right();
        });
        opsDurationConfig.opsDurations193_to_256().forEach(opsDurationPair -> {
            opsDurationByOpCodeArray[opsDurationPair.left().intValue()] = opsDurationPair.right();
        });
        return new OpsDurationSchedule(opsDurationByOpCodeArray, opsDurationConfig.opsGasBasedDurationMultiplier(), opsDurationConfig.precompileGasBasedDurationMultiplier(), opsDurationConfig.systemContractGasBasedDurationMultiplier(), opsDurationConfig.accountLazyCreationOpsDurationMultiplier(), 100L);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OpsDurationSchedule)) {
            return false;
        }
        OpsDurationSchedule that = (OpsDurationSchedule)o;
        return this.multipliersDenominator == that.multipliersDenominator && this.opsGasBasedDurationMultiplier == that.opsGasBasedDurationMultiplier && this.precompileGasBasedDurationMultiplier == that.precompileGasBasedDurationMultiplier && this.systemContractGasBasedDurationMultiplier == that.systemContractGasBasedDurationMultiplier && this.accountLazyCreationOpsDurationMultiplier == that.accountLazyCreationOpsDurationMultiplier && Arrays.equals(this.opsDurationByOpCode, that.opsDurationByOpCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.opsDurationByOpCode), this.opsGasBasedDurationMultiplier, this.precompileGasBasedDurationMultiplier, this.systemContractGasBasedDurationMultiplier, this.accountLazyCreationOpsDurationMultiplier, this.multipliersDenominator);
    }
}

