/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.state.StorageSizeChange;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import javax.inject.Inject;

@TransactionScope
public class StorageSizeValidator {
    private final ContractsConfig contractsConfig;

    @Inject
    public StorageSizeValidator(@NonNull ContractsConfig contractsConfig) {
        this.contractsConfig = contractsConfig;
    }

    public void assertValid(long aggregateSlotsUsed, @NonNull HederaOperations hederaOperations, @NonNull List<StorageSizeChange> storageSizeChanges) {
        long maxAggregateSlots = this.contractsConfig.maxKvPairsAggregate();
        ResourceExhaustedException.validateResource((maxAggregateSlots >= aggregateSlotsUsed ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED);
        int maxIndividualSlots = this.contractsConfig.maxKvPairsIndividual();
        storageSizeChanges.forEach(change -> {
            long contractSlotsUsed = (long)change.numAdded() + hederaOperations.getOriginalSlotsUsed(change.contractID());
            ResourceExhaustedException.validateResource(((long)maxIndividualSlots >= contractSlotsUsed ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED);
        });
    }
}

