/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.http.Status;
import java.nio.charset.StandardCharsets;

public final class Http1StatusParser {
    private Http1StatusParser() {
    }

    public static Status readStatus(DataReader reader, int maxLength) {
        int newLine = reader.findNewLine(maxLength);
        if (newLine == maxLength) {
            throw new IllegalStateException("HTTP Response did not contain HTTP status line. Line: \n" + reader.readBuffer(newLine).debugDataHex());
        }
        int slash = reader.findOrNewLine((byte)47, newLine);
        if (slash == newLine) {
            throw new IllegalStateException("HTTP Response did not contain HTTP status line. Line: \n" + reader.readBuffer(newLine).debugDataHex());
        }
        String protocol = reader.readAsciiString(slash);
        if (!protocol.equals("HTTP")) {
            throw new IllegalStateException("HTTP response did not contain correct status line. Protocol is not HTTP: \n" + BufferData.create((byte[])protocol.getBytes(StandardCharsets.US_ASCII)).debugDataHex());
        }
        reader.skip(1);
        newLine -= slash;
        int space = reader.findOrNewLine((byte)32, --newLine);
        if (space == newLine) {
            throw new IllegalStateException("HTTP Response did not contain HTTP status line. Line: HTTP/\n" + reader.readBuffer(newLine).debugDataHex());
        }
        String protocolVersion = reader.readAsciiString(space);
        reader.skip(1);
        newLine -= space;
        --newLine;
        if (!protocolVersion.equals("1.0") && !protocolVersion.equals("1.1")) {
            throw new IllegalStateException("HTTP response did not contain correct status line. Version is not 1.0 or 1.1: \n" + BufferData.create((byte[])protocolVersion.getBytes(StandardCharsets.US_ASCII)).debugDataHex());
        }
        space = reader.findOrNewLine((byte)32, newLine);
        if (space == newLine) {
            throw new IllegalStateException("HTTP Response did not contain HTTP status line. Line: HTTP/1.0 or HTTP/1.1\n" + reader.readBuffer(newLine).debugDataHex());
        }
        String code = reader.readAsciiString(space);
        reader.skip(1);
        newLine -= space;
        String phrase = reader.readAsciiString(--newLine);
        reader.skip(2);
        try {
            return Status.create((int)Integer.parseInt(code), (String)phrase);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("HTTP Response did not contain HTTP status line. Line HTTP/1.0 or HTTP/1.1 \n" + String.valueOf(BufferData.create((byte[])code.getBytes(StandardCharsets.US_ASCII))) + "\n" + String.valueOf(BufferData.create((byte[])phrase.getBytes(StandardCharsets.US_ASCII))));
        }
    }
}

