/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.util.Collection;
import java.util.Optional;

public final class Annotations {
    public static final Annotation OVERRIDE = Annotation.create(Override.class);
    public static final Annotation DEPRECATED = Annotation.create(Deprecated.class);

    private Annotations() {
    }

    public static <T extends Annotation> Optional<T> findFirst(TypeName annoTypeName, Collection<T> coll) {
        String name = annoTypeName.name();
        return coll.stream().filter(it -> it.typeName().name().equals(name)).findFirst();
    }

    public static <T extends Annotation> Optional<T> findFirst(Class<? extends java.lang.annotation.Annotation> annoType, Collection<T> coll) {
        return Annotations.findFirst(annoType.getTypeName(), coll);
    }

    public static <T extends Annotation> Optional<T> findFirst(String annoTypeName, Collection<T> coll) {
        assert (!annoTypeName.isBlank());
        return coll.stream().filter(it -> it.typeName().name().equals(annoTypeName)).findFirst();
    }
}

