/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.hyperledger.besu.datatypes.PublicKey;
import org.hyperledger.besu.ethereum.rlp.RLPException;
import org.hyperledger.besu.ethereum.rlp.RLPInput;

public class BLSPublicKey
extends DelegatingBytes
implements PublicKey {
    public static final int SIZE = 48;

    protected BLSPublicKey(Bytes bytes) {
        super(bytes);
    }

    public static BLSPublicKey wrap(Bytes value) {
        Preconditions.checkArgument((value.size() == 48 ? 1 : 0) != 0, (String)"A BLS public key must be %s bytes long, got %s", (int)48, (int)value.size());
        return new BLSPublicKey(value);
    }

    public static BLSPublicKey readFrom(RLPInput input) {
        Bytes bytes = input.readBytes();
        if (bytes.size() != 48) {
            throw new RLPException(String.format("BLSPublicKey unexpected size of %s (needs %s)", bytes.size(), 48));
        }
        return BLSPublicKey.wrap(bytes);
    }

    @JsonCreator
    public static BLSPublicKey fromHexString(String str) {
        if (str == null) {
            return null;
        }
        return BLSPublicKey.wrap(Bytes.fromHexStringLenient((CharSequence)str, (int)48));
    }
}

