/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenAssociateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.token.TokenAssociateUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenListChecks;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenAssociateToAccountHandler
extends BaseTokenHandler
implements TransactionHandler {
    @Inject
    public TokenAssociateToAccountHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenAssociateTransactionBody op = context.body().tokenAssociateOrThrow();
        AccountID target = op.accountOrElse(AccountID.DEFAULT);
        context.requireKeyOrThrow(target, ResponseCodeEnum.INVALID_ACCOUNT_ID);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        StoreFactory storeFactory = context.storeFactory();
        ReadableTokenStore tokenStore = Objects.requireNonNull((ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class));
        TokenAssociateTransactionBody op = context.body().tokenAssociateOrThrow();
        List<TokenID> tokenIds = op.tokens().stream().sorted(TokenComparators.TOKEN_ID_COMPARATOR).toList();
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        EntitiesConfig entitiesConfig = (EntitiesConfig)context.configuration().getConfigData(EntitiesConfig.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        Validated validated = this.validateSemantics(tokenIds, op.accountOrThrow(), tokensConfig, entitiesConfig, accountStore, tokenStore, tokenRelStore, context.expiryValidator());
        this.createAndLinkTokenRels(validated.account(), validated.tokens(), accountStore, tokenRelStore);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenAssociateTransactionBody op = txn.tokenAssociateOrThrow();
        PreCheckException.validateTruePreCheck((boolean)BaseCryptoHandler.hasAccountNumOrAlias(op.account()), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((boolean)op.tokens().contains(TokenID.DEFAULT), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateFalsePreCheck((boolean)TokenListChecks.repeatsItself(op.tokens()), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST);
    }

    @NonNull
    private Validated validateSemantics(@NonNull List<TokenID> tokenIds, @NonNull AccountID accountId, @NonNull TokensConfig tokenConfig, @NonNull EntitiesConfig entitiesConfig, @NonNull WritableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(tokenConfig);
        Objects.requireNonNull(entitiesConfig);
        HandleException.validateTrue((boolean)this.isTotalNumTokenRelsWithinMax(tokenIds.size(), tokenRelStore, tokenConfig.maxAggregateRels()), (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        Account account = TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (TokenID tokenId : tokenIds) {
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            tokens.add(token);
        }
        HandleException.validateTrue((boolean)this.maxAccountAssociationsAllowTokenRels(tokenConfig, entitiesConfig, account, tokenIds), (ResponseCodeEnum)ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED);
        for (TokenID tokenId : tokenIds) {
            TokenRelation existingTokenRel = tokenRelStore.get(accountId, tokenId);
            HandleException.validateTrue((existingTokenRel == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT);
        }
        return new Validated(account, tokens);
    }

    private boolean isTotalNumTokenRelsWithinMax(int numNewTokenRels, WritableTokenRelationStore tokenRelStore, long maxNumTokenRels) {
        return tokenRelStore.sizeOfState() + (long)numNewTokenRels <= maxNumTokenRels;
    }

    private boolean maxAccountAssociationsAllowTokenRels(@NonNull TokensConfig config, @NonNull EntitiesConfig entitiesConfig, @NonNull Account account, @NonNull List<TokenID> tokenIds) {
        int numAssociations = Objects.requireNonNull(account).numberAssociations();
        boolean tokenAssociationsLimited = entitiesConfig.limitTokenAssociations();
        int maxTokensPerAccount = config.maxPerAccount();
        return !tokenAssociationsLimited || numAssociations + tokenIds.size() <= maxTokensPerAccount;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        TokenAssociateTransactionBody op = body.tokenAssociateOrThrow();
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        boolean unlimitedAssociationsEnabled = ((EntitiesConfig)feeContext.configuration().getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled();
        if (unlimitedAssociationsEnabled) {
            calculator.resetUsage();
            calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
            calculator.addBytesPerTransaction((long)op.tokens().size());
            return calculator.calculate();
        }
        AccountID accountId = op.accountOrThrow();
        ReadableAccountStore readableAccountStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        Account account = readableAccountStore.getAccountById(accountId);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj, account));
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo, Account account) {
        if (account == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        TokenAssociateUsage estimate = new TokenAssociateUsage(txn, new TxnUsageEstimator(sigUsage, txn, (EstimatorUtils)SingletonEstimatorUtils.ESTIMATOR_UTILS));
        return estimate.givenCurrentExpiry(account.expirationSecond()).get();
    }

    private record Validated(@NonNull Account account, @NonNull List<Token> tokens) {
    }
}

