/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.io.IOIterator;
import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;

public class PcesMultiFileIterator
implements IOIterator<PlatformEvent> {
    private final Iterator<PcesFile> fileIterator;
    private PcesFileIterator currentIterator;
    private final long lowerBound;
    private PlatformEvent next;
    private int truncatedFileCount = 0;

    public PcesMultiFileIterator(long lowerBound, @NonNull Iterator<PcesFile> fileIterator) {
        this.fileIterator = Objects.requireNonNull(fileIterator);
        this.lowerBound = lowerBound;
    }

    private void findNext() throws IOException {
        if (this.currentIterator == null) {
            if (this.fileIterator.hasNext()) {
                this.currentIterator = new PcesFileIterator(this.fileIterator.next(), this.lowerBound);
            } else {
                return;
            }
        }
        while (this.next == null) {
            boolean hasNextEvent = false;
            try {
                hasNextEvent = this.currentIterator.hasNext();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (hasNextEvent) {
                this.next = this.currentIterator.next();
                return;
            }
            if (this.currentIterator.hasPartialEvent()) {
                ++this.truncatedFileCount;
            }
            if (!this.fileIterator.hasNext()) {
                return;
            }
            this.currentIterator = new PcesFileIterator(this.fileIterator.next(), this.lowerBound);
        }
    }

    public boolean hasNext() throws IOException {
        this.findNext();
        return this.next != null;
    }

    @NonNull
    public PlatformEvent next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("iterator is empty, can not get next element");
        }
        try {
            PlatformEvent platformEvent = this.next;
            return platformEvent;
        }
        finally {
            this.next = null;
        }
    }

    public int getTruncatedFileCount() {
        return this.truncatedFileCount;
    }
}

