/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.state.notifications;

import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.notification.AbstractNotification;

public class StateHashedNotification
extends AbstractNotification {
    private final long roundNumber;
    private final Hash hash;

    public static StateHashedNotification from(@NonNull ReservedSignedState state) {
        try (ReservedSignedState reservedSignedState = state;){
            StateHashedNotification stateHashedNotification = new StateHashedNotification(state.get().getRound(), Objects.requireNonNull(state.get().getState().getHash()));
            return stateHashedNotification;
        }
    }

    public StateHashedNotification(long roundNumber, @NonNull Hash hash) {
        this.roundNumber = roundNumber;
        this.hash = Objects.requireNonNull(hash);
    }

    public long round() {
        return this.roundNumber;
    }

    @NonNull
    public Hash hash() {
        return this.hash;
    }
}

