/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.file.FileCreateTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.file.FileOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.service.file.impl.records.CreateFileStreamBuilder;
import com.hedera.node.app.service.file.impl.utils.FileServiceUtils;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileCreateHandler
implements TransactionHandler {
    private final FileOpsUsage fileOpsUsage;

    @Inject
    public FileCreateHandler(FileOpsUsage fileOpsUsage) {
        this.fileOpsUsage = fileOpsUsage;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        FileCreateTransactionBody transactionBody = context.body().fileCreateOrThrow();
        if (!transactionBody.hasExpirationTime()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_EXPIRATION_TIME);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        FileCreateTransactionBody transactionBody = context.body().fileCreateOrThrow();
        FileServiceUtils.validateAndAddRequiredKeys(null, transactionBody.keys(), context);
    }

    public void handle(@NonNull HandleContext handleContext) throws HandleException {
        WritableFileStore fileStore;
        Objects.requireNonNull(handleContext);
        File.Builder builder = new File.Builder();
        FilesConfig fileServiceConfig = (FilesConfig)handleContext.configuration().getConfigData(FilesConfig.class);
        FileCreateTransactionBody fileCreateTransactionBody = handleContext.body().fileCreateOrThrow();
        if (fileCreateTransactionBody.hasKeys()) {
            KeyList transactionKeyList = fileCreateTransactionBody.keys();
            builder.keys(transactionKeyList);
        }
        if ((fileStore = (WritableFileStore)handleContext.storeFactory().writableStore(WritableFileStore.class)).sizeOfState() >= fileServiceConfig.maxNumber()) {
            throw new HandleException(ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        }
        long expiry = fileCreateTransactionBody.hasExpirationTime() ? fileCreateTransactionBody.expirationTimeOrThrow().seconds() : ExpiryMeta.NA;
        ExpiryMeta entityExpiryMeta = new ExpiryMeta(expiry, ExpiryMeta.NA, null);
        try {
            ExpiryMeta effectiveExpiryMeta = handleContext.expiryValidator().resolveCreationAttempt(false, entityExpiryMeta, HederaFunctionality.FILE_CREATE);
            builder.expirationSecond(effectiveExpiryMeta.expiry());
            handleContext.attributeValidator().validateMemo(fileCreateTransactionBody.memo());
            builder.memo(fileCreateTransactionBody.memo());
            HederaConfig hederaConfig = (HederaConfig)handleContext.configuration().getConfigData(HederaConfig.class);
            builder.keys(fileCreateTransactionBody.keys());
            FileID fileId = FileID.newBuilder().fileNum(handleContext.entityNumGenerator().newEntityNum()).shardNum(fileCreateTransactionBody.hasShardID() ? fileCreateTransactionBody.shardIDOrThrow().shardNum() : hederaConfig.shard()).realmNum(fileCreateTransactionBody.hasRealmID() ? fileCreateTransactionBody.realmIDOrThrow().realmNum() : hederaConfig.realm()).build();
            builder.fileId(fileId);
            FileServiceUtils.validateContent(CommonPbjConverters.asBytes((Bytes)fileCreateTransactionBody.contents()), fileServiceConfig);
            builder.contents(fileCreateTransactionBody.contents());
            File file = builder.build();
            fileStore.putAndIncrementCount(file);
            ((CreateFileStreamBuilder)handleContext.savepointStack().getBaseBuilder(CreateFileStreamBuilder.class)).fileID(fileId);
        }
        catch (HandleException e) {
            if (e.getStatus() == ResponseCodeEnum.INVALID_EXPIRATION_TIME) {
                throw new HandleException(ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE);
            }
            throw e;
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody txnBody = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(svo -> this.fileOpsUsage.fileCreateUsage(CommonPbjConverters.fromPbj((TransactionBody)txnBody), new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount())));
    }
}

