/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.congestion;

import com.hedera.node.app.hapi.utils.throttles.CongestibleThrottle;
import com.hedera.node.config.types.CongestionMultipliers;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottleMultiplier {
    private static final Logger logger = LogManager.getLogger(ThrottleMultiplier.class);
    private static final long DEFAULT_MULTIPLIER = 1L;
    private static final Instant[] NO_CONGESTION_STARTS = new Instant[0];
    private final Supplier<CongestionMultipliers> multiplierSupplier;
    private final String congestionType;
    private final String usageType;
    private final String abbrevUsageType;
    private final LongSupplier minCongestionPeriodSupplier;
    private final Supplier<List<? extends CongestibleThrottle>> throttleSource;
    private long multiplier = 1L;
    private long previousMultiplier = 1L;
    private CongestionMultipliers activeConfig = null;
    private List<? extends CongestibleThrottle> activeThrottles = Collections.emptyList();
    private long[][] activeTriggerValues = new long[0][];
    private Instant[] congestionLevelStarts = NO_CONGESTION_STARTS;

    public ThrottleMultiplier(@NonNull String usageType, @NonNull String abbrevUsageType, @NonNull String congestionType, @NonNull LongSupplier minCongestionPeriodSupplier, @NonNull Supplier<CongestionMultipliers> multiplierSupplier, @NonNull Supplier<List<? extends CongestibleThrottle>> throttleSource) {
        this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
        this.abbrevUsageType = Objects.requireNonNull(abbrevUsageType, "abbrevUsageType must not be null");
        this.congestionType = Objects.requireNonNull(congestionType, "congestionType must not be null");
        this.minCongestionPeriodSupplier = Objects.requireNonNull(minCongestionPeriodSupplier, "minCongestionPeriodSupplier must not be null");
        this.multiplierSupplier = Objects.requireNonNull(multiplierSupplier, "multiplierSupplier must not be null");
        this.throttleSource = Objects.requireNonNull(throttleSource, "throttleSource must not be null");
    }

    public void updateMultiplier(@NonNull Instant consensusTime) {
        if (this.ensureConfigUpToDate()) {
            this.rebuildState();
        }
        long x = this.maxMultiplierOfActiveConfig(this.activeConfig.multipliers());
        this.updateCongestionLevelStartsWith(this.activeConfig.multipliers(), x, consensusTime);
        long minPeriod = this.minCongestionPeriodSupplier.getAsLong();
        this.multiplier = this.highestMultiplierNotShorterThan(this.activeConfig.multipliers(), minPeriod, consensusTime);
        if (this.multiplier != this.previousMultiplier) {
            this.logMultiplierChange(this.previousMultiplier, this.multiplier);
        }
        this.previousMultiplier = this.multiplier;
    }

    public long currentMultiplier() {
        return this.multiplier;
    }

    public void resetExpectations() {
        this.activeThrottles = this.throttleSource.get();
        if (this.activeThrottles.isEmpty()) {
            logger.warn("Throttle multiplier for {} congestion has no throttle buckets, fee multiplier will remain at one!", (Object)this.congestionType);
        }
        this.ensureConfigUpToDate();
        this.rebuildState();
    }

    public void resetCongestionLevelStarts(@NonNull Instant[] startTimes) {
        this.congestionLevelStarts = (Instant[])startTimes.clone();
    }

    @NonNull
    public Instant[] congestionLevelStarts() {
        return (Instant[])this.congestionLevelStarts.clone();
    }

    @NonNull
    public String toString() {
        if (this.activeConfig == null) {
            return " <N/A>";
        }
        StringBuilder sb = new StringBuilder();
        long[] multipliers = this.activeConfig.multipliers();
        int n = this.activeThrottles.size();
        for (int i = 0; i < n; ++i) {
            CongestibleThrottle throttle = this.activeThrottles.get(i);
            sb.append("\n  (").append(throttle.name()).append(") When ").append(this.usageType).append(" exceeds:\n");
            for (int j = 0; j < multipliers.length; ++j) {
                sb.append("    ").append(this.readableTpsCutoffFor(this.activeTriggerValues[i][j], throttle.mtps(), throttle.capacity())).append(" ").append(this.abbrevUsageType).append(", multiplier is ").append(multipliers[j]).append("x").append(j == multipliers.length - 1 ? "" : "\n");
            }
        }
        return sb.toString();
    }

    @NonNull
    private String readableTpsCutoffFor(long capacityCutoff, long mtps, long capacity) {
        return String.format("%.2f", (double)capacityCutoff * 1.0 / (double)capacity * (double)mtps / 1000.0);
    }

    private boolean ensureConfigUpToDate() {
        CongestionMultipliers currConfig = this.multiplierSupplier.get();
        if (!currConfig.equals((Object)this.activeConfig)) {
            this.activeConfig = currConfig;
            return true;
        }
        return false;
    }

    private void rebuildState() {
        int n = this.activeThrottles.size();
        int[] triggers = this.activeConfig.usagePercentTriggers();
        long[] multipliers = this.activeConfig.multipliers();
        this.activeTriggerValues = new long[n][multipliers.length];
        for (int i = 0; i < n; ++i) {
            CongestibleThrottle throttle = this.activeThrottles.get(i);
            long capacity = throttle.capacity();
            for (int j = 0; j < triggers.length; ++j) {
                long cutoff;
                this.activeTriggerValues[i][j] = cutoff = capacity / 100L * (long)triggers[j];
            }
        }
        this.congestionLevelStarts = new Instant[multipliers.length];
        this.logReadableCutoffs();
    }

    private long maxMultiplierOfActiveConfig(@NonNull long[] multipliers) {
        long max = 1L;
        for (int i = 0; i < this.activeTriggerValues.length; ++i) {
            long used = this.activeThrottles.get(i).used();
            for (int j = 0; j < multipliers.length; ++j) {
                if (used < this.activeTriggerValues[i][j]) continue;
                max = Math.max(max, multipliers[j]);
            }
        }
        return max;
    }

    private void updateCongestionLevelStartsWith(@NonNull long[] multipliers, long x, @NonNull Instant consensusNow) {
        for (int i = 0; i < multipliers.length; ++i) {
            if (x < multipliers[i]) {
                this.congestionLevelStarts[i] = null;
                continue;
            }
            if (this.congestionLevelStarts[i] != null) continue;
            this.congestionLevelStarts[i] = consensusNow;
        }
    }

    private long highestMultiplierNotShorterThan(@NonNull long[] multipliers, long period, @NonNull Instant consensusNow) {
        this.multiplier = 1L;
        for (int i = multipliers.length - 1; i >= 0; --i) {
            long secsAtLevel;
            Instant levelStart = this.congestionLevelStarts[i];
            if (levelStart == null || (secsAtLevel = Duration.between(levelStart, consensusNow).getSeconds()) < period) continue;
            this.multiplier = multipliers[i];
            break;
        }
        return this.multiplier;
    }

    private void logReadableCutoffs() {
        logger.info("The new cutoffs for {} congestion pricing are : {}", (Object)this.congestionType, (Object)this);
    }

    public void logMultiplierChange(long prev, long cur) {
        if (prev == 1L) {
            logger.info("Congestion pricing beginning w/ {}x multiplier", (Object)cur);
        } else if (cur > prev) {
            logger.info("Congestion pricing continuing, reached {}x multiplier", (Object)cur);
        } else if (cur == 1L) {
            logger.info("Congestion pricing ended");
        }
    }
}

