/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.InertProofController;
import com.hedera.node.app.history.impl.ProofController;
import com.hedera.node.app.history.impl.ProofControllerImpl;
import com.hedera.node.app.history.impl.ProofKeysAccessor;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.app.roster.RosterTransitionWeights;
import com.hedera.node.app.spi.info.NodeInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProofControllers {
    private static final long NO_CONSTRUCTION_ID = -1L;
    private final Executor executor;
    private final ProofKeysAccessor keyAccessor;
    private final HistoryLibrary library;
    private final HistorySubmissions submissions;
    private final Supplier<NodeInfo> selfNodeInfoSupplier;
    private final Consumer<HistoryProof> proofConsumer;
    @Nullable
    private ProofController controller;

    @Inject
    public ProofControllers(@NonNull Executor executor, @NonNull ProofKeysAccessor keyAccessor, @NonNull HistoryLibrary library, @NonNull HistorySubmissions submissions, @NonNull Supplier<NodeInfo> selfNodeInfoSupplier, @NonNull Consumer<HistoryProof> proofConsumer) {
        this.executor = Objects.requireNonNull(executor);
        this.keyAccessor = Objects.requireNonNull(keyAccessor);
        this.library = Objects.requireNonNull(library);
        this.submissions = Objects.requireNonNull(submissions);
        this.selfNodeInfoSupplier = Objects.requireNonNull(selfNodeInfoSupplier);
        this.proofConsumer = Objects.requireNonNull(proofConsumer);
    }

    @NonNull
    public ProofController getOrCreateFor(@NonNull ActiveRosters activeRosters, @NonNull HistoryProofConstruction construction, @NonNull ReadableHistoryStore historyStore) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(historyStore);
        if (this.currentConstructionId() != construction.constructionId()) {
            if (this.controller != null) {
                this.controller.cancelPendingWork();
            }
            this.controller = this.newControllerFor(activeRosters, construction, historyStore);
        }
        return Objects.requireNonNull(this.controller);
    }

    public Optional<ProofController> getInProgressById(long constructionId) {
        return this.currentConstructionId() == constructionId ? Optional.ofNullable(this.controller).filter(ProofController::isStillInProgress) : Optional.empty();
    }

    public Optional<ProofController> getAnyInProgress() {
        return Optional.ofNullable(this.controller).filter(ProofController::isStillInProgress);
    }

    private ProofController newControllerFor(@NonNull ActiveRosters activeRosters, @NonNull HistoryProofConstruction construction, @NonNull ReadableHistoryStore historyStore) {
        RosterTransitionWeights weights = activeRosters.transitionWeights();
        if (!weights.sourceNodesHaveTargetThreshold()) {
            return new InertProofController(construction.constructionId());
        }
        List<ReadableHistoryStore.ProofKeyPublication> keyPublications = historyStore.getProofKeyPublications(weights.targetNodeIds());
        List<ReadableHistoryStore.HistorySignaturePublication> signaturePublications = historyStore.getSignaturePublications(construction.constructionId(), weights.targetNodeIds());
        Map<Long, HistoryProofVote> votes = historyStore.getVotes(construction.constructionId(), weights.sourceNodeIds());
        long selfId = this.selfNodeInfoSupplier.get().nodeId();
        ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair = this.keyAccessor.getOrCreateSchnorrKeyPair(construction.constructionId());
        return new ProofControllerImpl(selfId, schnorrKeyPair, historyStore.getLedgerId(), construction, weights, this.executor, this.library, this.submissions, keyPublications, signaturePublications, votes, this.proofConsumer);
    }

    private long currentConstructionId() {
        return this.controller != null ? this.controller.constructionId() : -1L;
    }
}

