/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats.v6;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.node.app.records.impl.producers.BlockRecordFormat;
import com.hedera.node.app.records.impl.producers.SerializedSingleTransactionRecord;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.List;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class BlockRecordFormatV6
implements BlockRecordFormat {
    private static final long RECORD_STREAM_OBJECT_CLASS_ID = -2057983832518124149L;
    public static final int RECORD_STREAM_OBJECT_CLASS_VERSION = 1;
    public static final int VERSION_6 = 6;
    private static final byte[] RECORD_STREAM_OBJECT_HEADER;
    static final byte[] HASH_HEADER;
    public static final BlockRecordFormat INSTANCE;

    private BlockRecordFormatV6() {
    }

    @Override
    public SerializedSingleTransactionRecord serialize(@NonNull SingleTransactionRecord singleTransactionRecord, long blockNumber, @NonNull SemanticVersion hapiVersion) {
        try {
            RecordStreamItem recordStreamItem = new RecordStreamItem(singleTransactionRecord.transaction(), singleTransactionRecord.transactionRecord());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(RECORD_STREAM_OBJECT_HEADER);
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            if (recordStreamItem.record() != null) {
                Bytes transactionRecordProtobufBytes = TransactionRecord.PROTOBUF.toBytes((Object)recordStreamItem.record());
                out.writeInt((int)transactionRecordProtobufBytes.length());
                transactionRecordProtobufBytes.writeTo((WritableSequentialData)out);
            }
            if (recordStreamItem.transaction() != null) {
                Bytes transactionProtobufBytes = Transaction.PROTOBUF.toBytes((Object)recordStreamItem.transaction());
                out.writeInt((int)transactionProtobufBytes.length());
                transactionProtobufBytes.writeTo((WritableSequentialData)out);
            }
            Bytes protobufItemBytes = RecordStreamItem.PROTOBUF.toBytes((Object)recordStreamItem);
            List<Bytes> sideCarItems = singleTransactionRecord.transactionSidecarRecords().stream().map(arg_0 -> ((Codec)TransactionSidecarRecord.PROTOBUF).toBytes(arg_0)).toList();
            return new SerializedSingleTransactionRecord(Bytes.wrap((byte[])bout.toByteArray()), protobufItemBytes, sideCarItems, singleTransactionRecord.transactionSidecarRecords());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Bytes computeNewRunningHash(@NonNull Bytes startRunningHash, @NonNull List<SerializedSingleTransactionRecord> serializedItems) {
        try {
            byte[] previousHash = startRunningHash.toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            int count = serializedItems.size();
            for (int i = 0; i < count; ++i) {
                SerializedSingleTransactionRecord serializedItem = serializedItems.get(i);
                serializedItem.hashSerializedRecordStreamItem().writeTo(messageDigest);
                byte[] serializedItemHash = messageDigest.digest();
                messageDigest.update(HASH_HEADER);
                messageDigest.update(previousHash);
                messageDigest.update(HASH_HEADER);
                messageDigest.update(serializedItemHash);
                previousHash = messageDigest.digest();
            }
            return Bytes.wrap((byte[])previousHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        INSTANCE = new BlockRecordFormatV6();
        try {
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putLong(-854880720348154850L);
            buf.putInt(new Hash().getVersion());
            HASH_HEADER = buf.array();
            assert (Arrays.equals(HASH_HEADER, HexFormat.of().parseHex("1e7451a283da22f401000000"))) : "Hash object header is not the expected 1e7451a283da22f401000000";
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            SerializableDataOutputStream sout = new SerializableDataOutputStream((OutputStream)bout);
            bout.reset();
            sout.writeLong(-2057983832518124149L);
            sout.writeInt(1);
            RECORD_STREAM_OBJECT_HEADER = bout.toByteArray();
            assert (Arrays.equals(RECORD_STREAM_OBJECT_HEADER, HexFormat.of().parseHex("e370929ba5429d8b00000001"))) : "RecordStreamObject header is not the expected e370929ba5429d8b00000001";
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

