/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.tss;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SequentialContentManager<T> {
    private static final Logger log = LogManager.getLogger(SequentialContentManager.class);
    private static final Pattern SEQ_NO_DIR_PATTERN = Pattern.compile("\\d+");
    private final Path path;
    private final String contentDesc;
    private final String contentFileName;
    private final Supplier<T> contentSupplier;
    private final ContentReader<T> contentReader;
    private final ContentWriter<T> contentWriter;

    public SequentialContentManager(@NonNull Path path, @NonNull String contentDesc, @NonNull String contentFileName, @NonNull Supplier<T> contentSupplier, @NonNull ContentReader<T> contentReader, @NonNull ContentWriter<T> contentWriter) {
        this.path = Objects.requireNonNull(path);
        this.contentDesc = contentDesc;
        this.contentFileName = Objects.requireNonNull(contentFileName);
        this.contentReader = Objects.requireNonNull(contentReader);
        this.contentWriter = Objects.requireNonNull(contentWriter);
        this.contentSupplier = Objects.requireNonNull(contentSupplier);
    }

    public T getOrCreateContent(long seqNo) {
        return (T)this.findLatestContentFor(seqNo).orElseGet(() -> {
            log.info("No usable {} found for #{}, creating one", (Object)this.contentDesc, (Object)seqNo);
            return this.createContentFor(seqNo);
        });
    }

    public T createContentFor(long seqNo) {
        this.assertNoExtantContentFor(seqNo);
        Path dirPath = this.path.resolve(String.valueOf(seqNo));
        log.info("Creating new subdirectory {} for #{}", (Object)dirPath.toAbsolutePath(), (Object)seqNo);
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create directory for #" + seqNo, e);
        }
        return this.writeNewContentAt(this.pathFor(seqNo));
    }

    public void purgeContentBefore(long seqNo) {
        log.info("Purging any content directories below #{}", (Object)seqNo);
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            log.warn("Base directory {} is not an extant directory, skipping purge", (Object)this.path.toAbsolutePath());
            return;
        }
        try (Stream<Path> contents = Files.list(this.path);){
            contents.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(this::isContentDir).map(this::sequenceNumberOf).filter(id -> id < seqNo).forEach(m -> {
                Path dir = this.path.resolve(String.valueOf(m));
                log.info("Removing directory {}", (Object)dir.toAbsolutePath());
                try {
                    SequentialContentManager.rm(dir);
                }
                catch (UncheckedIOException e) {
                    log.warn("Failed to remove {}", (Object)dir.toAbsolutePath(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            log.warn("Failed to list directories in {}", (Object)this.path.toAbsolutePath(), (Object)e);
        }
    }

    private Optional<T> findLatestContentFor(long seqNo) {
        Optional optional;
        block9: {
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                return Optional.empty();
            }
            Stream<Path> contents = Files.list(this.path);
            try {
                Optional content = contents.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(this::isContentDir).map(this::sequenceNumberOf).filter(id -> id <= seqNo).max(Long::compareTo).map(this::pathFor).flatMap(this::tryToReadContent);
                content.ifPresent(ignore -> log.info("Loaded existing {} for #{}", (Object)this.contentDesc, (Object)seqNo));
                optional = content;
                if (contents == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Failed to list directories in {}", (Object)this.path, (Object)e);
                    return Optional.empty();
                }
            }
            contents.close();
        }
        return optional;
    }

    private long sequenceNumberOf(Path dir) {
        return Long.parseLong(dir.getFileName().toString());
    }

    private boolean isContentDir(Path dir) {
        return SEQ_NO_DIR_PATTERN.matcher(dir.getFileName().toString()).matches();
    }

    private Path pathFor(long seqNo) {
        return this.path.resolve(String.valueOf(seqNo)).resolve(this.contentFileName);
    }

    private T writeNewContentAt(@NonNull Path p) {
        T newContent = this.contentSupplier.get();
        try {
            this.contentWriter.writeContent(newContent, p);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return newContent;
    }

    private Optional<T> tryToReadContent(@NonNull Path p) {
        if (!Files.exists(p, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.contentReader.readContent(p));
        }
        catch (Exception e) {
            log.warn("Unable to read content from {}", (Object)p.toAbsolutePath(), (Object)e);
            return Optional.empty();
        }
    }

    private void assertNoExtantContentFor(long seqNo) {
        Path p = this.pathFor(seqNo);
        try {
            this.contentReader.readContent(p);
            throw new IllegalArgumentException("Content already exists for #" + seqNo + " at " + String.valueOf(p.toAbsolutePath()));
        }
        catch (Exception exception) {
            return;
        }
    }

    static void rm(@NonNull Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface ContentReader<R> {
        @NonNull
        public R readContent(@NonNull Path var1) throws IOException;
    }

    @FunctionalInterface
    public static interface ContentWriter<R> {
        public void writeContent(@NonNull R var1, @NonNull Path var2) throws IOException;
    }
}

