/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.fees.AppFeeCharging;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.service.contract.impl.handlers.EthereumTransactionHandler;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.dispatch.DispatchValidator;
import com.hedera.node.app.workflows.handle.dispatch.RecordFinalizer;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.steps.PlatformStateUpdates;
import com.hedera.node.app.workflows.handle.steps.SystemFileUpdates;
import com.hedera.node.app.workflows.handle.throttle.DispatchUsageManager;
import com.hedera.node.app.workflows.handle.throttle.ThrottleException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class DispatchProcessor {
    private static final Logger logger = LogManager.getLogger(DispatchProcessor.class);
    private final Authorizer authorizer;
    private final DispatchValidator validator;
    private final RecordFinalizer recordFinalizer;
    private final SystemFileUpdates systemFileUpdates;
    private final PlatformStateUpdates platformStateUpdates;
    private final DispatchUsageManager dispatchUsageManager;
    private final ExchangeRateManager exchangeRateManager;
    private final TransactionDispatcher dispatcher;
    private final EthereumTransactionHandler ethereumTransactionHandler;
    private final NetworkInfo networkInfo;
    private final OpWorkflowMetrics workflowMetrics;
    private final AppFeeCharging appFeeCharging;

    @Inject
    public DispatchProcessor(@NonNull Authorizer authorizer, @NonNull DispatchValidator validator, @NonNull RecordFinalizer recordFinalizer, @NonNull SystemFileUpdates systemFileUpdates, @NonNull PlatformStateUpdates platformStateUpdates, @NonNull DispatchUsageManager dispatchUsageManager, @NonNull ExchangeRateManager exchangeRateManager, @NonNull TransactionDispatcher dispatcher, @NonNull EthereumTransactionHandler ethereumTransactionHandler, @NonNull NetworkInfo networkInfo, @NonNull OpWorkflowMetrics workflowMetrics, @NonNull AppFeeCharging appFeeCharging) {
        this.authorizer = Objects.requireNonNull(authorizer);
        this.validator = Objects.requireNonNull(validator);
        this.recordFinalizer = Objects.requireNonNull(recordFinalizer);
        this.systemFileUpdates = Objects.requireNonNull(systemFileUpdates);
        this.platformStateUpdates = Objects.requireNonNull(platformStateUpdates);
        this.dispatchUsageManager = Objects.requireNonNull(dispatchUsageManager);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.ethereumTransactionHandler = Objects.requireNonNull(ethereumTransactionHandler);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.workflowMetrics = Objects.requireNonNull(workflowMetrics);
        this.appFeeCharging = Objects.requireNonNull(appFeeCharging);
    }

    public void processDispatch(@NonNull Dispatch dispatch) {
        Objects.requireNonNull(dispatch);
        FeeCharging.Validation validation = this.validator.validateFeeChargingScenario(dispatch);
        if (!validation.creatorDidDueDiligence()) {
            this.chargeCreator(dispatch, validation);
        } else {
            Fees fees = this.chargePayer(dispatch, validation, false);
            if (!this.alreadyFailed(dispatch, validation)) {
                this.tryHandle(dispatch, validation, fees);
            }
        }
        this.dispatchUsageManager.finalizeAndSaveUsage(dispatch);
        this.recordFinalizer.finalizeRecord(dispatch);
        dispatch.stack().commitFullStack();
    }

    private void tryHandle(@NonNull Dispatch dispatch, @NonNull FeeCharging.Validation validation, @NonNull Fees fees) {
        HederaFunctionality functionality = dispatch.txnInfo().functionality();
        try {
            boolean refundsEnabled;
            this.dispatchUsageManager.screenForCapacity(dispatch);
            this.dispatcher.dispatchHandle(dispatch.handleContext());
            dispatch.streamBuilder().status(ResponseCodeEnum.SUCCESS);
            if (functionality == HederaFunctionality.ETHEREUM_TRANSACTION && (refundsEnabled = ((ContractsConfig)dispatch.config().getConfigData(ContractsConfig.class)).evmEthTransactionZeroHapiFeesEnabled())) {
                dispatch.feeChargingOrElse(this.appFeeCharging).refund((FeeCharging.Context)dispatch, fees);
            }
            this.handleSystemUpdates(dispatch);
        }
        catch (HandleException e) {
            this.rollback(e.getStatus(), dispatch.stack(), dispatch.streamBuilder());
            this.chargePayer(dispatch, validation, false);
            e.maybeReplayFees((FeeCharging.Context)dispatch);
        }
        catch (ThrottleException e) {
            this.workflowMetrics.incrementThrottled(functionality);
            this.rollbackAndRechargeFee(dispatch, validation, e.getStatus());
            if (functionality == HederaFunctionality.ETHEREUM_TRANSACTION) {
                this.ethereumTransactionHandler.handleThrottled(dispatch.handleContext());
            }
        }
        catch (Exception e) {
            logger.error("{} - exception thrown while handling dispatch", (Object)"Possibly CATASTROPHIC failure", (Object)e);
            this.rollbackAndRechargeFee(dispatch, validation, ResponseCodeEnum.FAIL_INVALID);
        }
    }

    private void handleSystemUpdates(Dispatch dispatch) {
        ResponseCodeEnum fileUpdateResult = this.systemFileUpdates.handleTxBody(dispatch.stack(), dispatch.txnInfo().txBody());
        dispatch.streamBuilder().exchangeRate(this.exchangeRateManager.exchangeRates()).status(fileUpdateResult);
        this.platformStateUpdates.handleTxBody(dispatch.stack(), dispatch.txnInfo().txBody(), dispatch.config());
        if (dispatch.txnInfo().functionality() == HederaFunctionality.NODE_UPDATE) {
            this.networkInfo.updateFrom((State)dispatch.stack());
        }
    }

    private void rollbackAndRechargeFee(@NonNull Dispatch dispatch, @NonNull FeeCharging.Validation validation, @NonNull ResponseCodeEnum status) {
        this.rollback(status, dispatch.stack(), dispatch.streamBuilder());
        this.chargePayer(dispatch, validation, true);
        this.dispatchUsageManager.trackFeePayments(dispatch);
    }

    private void chargeCreator(@NonNull Dispatch dispatch, @NonNull FeeCharging.Validation validation) {
        dispatch.streamBuilder().status(validation.errorStatusOrThrow());
        if (dispatch.category() == HandleContext.TransactionCategory.BATCH_INNER) {
            return;
        }
        dispatch.feeAccumulator().chargeFee(dispatch.creatorInfo().accountId(), dispatch.fees().networkFee(), null);
    }

    private Fees chargePayer(@NonNull Dispatch dispatch, @NonNull FeeCharging.Validation validation, boolean waiveServiceFee) {
        Fees fees = dispatch.fees();
        if (fees.nothingToCharge()) {
            return Fees.FREE;
        }
        boolean hasWaivedFees = this.authorizer.hasWaivedFees(dispatch.payerId(), dispatch.txnInfo().functionality(), dispatch.txnInfo().txBody());
        if (hasWaivedFees) {
            return Fees.FREE;
        }
        Fees feesToCharge = waiveServiceFee ? fees.withoutServiceComponent() : fees;
        return dispatch.feeChargingOrElse(this.appFeeCharging).charge((FeeCharging.Context)dispatch, validation, feesToCharge);
    }

    private void rollback(@NonNull ResponseCodeEnum status, @NonNull SavepointStackImpl stack, @NonNull StreamBuilder builder) {
        builder.status(status);
        stack.rollbackFullStack();
    }

    private boolean alreadyFailed(@NonNull Dispatch dispatch, @NonNull FeeCharging.Validation validation) {
        if (validation.maybeErrorStatus() != null) {
            dispatch.streamBuilder().status(validation.errorStatusOrThrow());
            return true;
        }
        ResponseCodeEnum authorizationFailure = this.maybeAuthorizationFailure(dispatch);
        if (authorizationFailure != null) {
            dispatch.streamBuilder().status(authorizationFailure);
            return true;
        }
        if (this.failsSignatureVerification(dispatch)) {
            dispatch.streamBuilder().status(ResponseCodeEnum.INVALID_SIGNATURE);
            return true;
        }
        return false;
    }

    @Nullable
    private ResponseCodeEnum maybeAuthorizationFailure(@NonNull Dispatch dispatch) {
        HederaFunctionality function = dispatch.txnInfo().functionality();
        if (!this.authorizer.isAuthorized(dispatch.payerId(), function)) {
            NetworkAdminConfig adminConfig;
            Set allowList;
            if (dispatch.txnCategory() == HandleContext.TransactionCategory.NODE && (allowList = (adminConfig = (NetworkAdminConfig)dispatch.config().getConfigData(NetworkAdminConfig.class)).nodeTransactionsAllowList().functionalitySet()).contains(function)) {
                return null;
            }
            return function == HederaFunctionality.SYSTEM_DELETE ? ResponseCodeEnum.NOT_SUPPORTED : ResponseCodeEnum.UNAUTHORIZED;
        }
        SystemPrivilege failure = this.authorizer.hasPrivilegedAuthorization(dispatch.payerId(), dispatch.txnInfo().functionality(), dispatch.txnInfo().txBody());
        return switch (failure) {
            case SystemPrivilege.UNAUTHORIZED -> ResponseCodeEnum.AUTHORIZATION_FAILED;
            case SystemPrivilege.IMPERMISSIBLE -> ResponseCodeEnum.ENTITY_NOT_ALLOWED_TO_DELETE;
            default -> null;
        };
    }

    private boolean failsSignatureVerification(@NonNull Dispatch dispatch) {
        SignatureVerification verification;
        for (Key key : dispatch.requiredKeys()) {
            verification = dispatch.keyVerifier().verificationFor(key);
            if (!verification.failed()) continue;
            return true;
        }
        for (Account hollowAccount : dispatch.hollowAccounts()) {
            verification = dispatch.keyVerifier().verificationFor(hollowAccount.alias());
            if (!verification.failed()) continue;
            return true;
        }
        return false;
    }
}

