/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.swirlds.state.spi.WritableQueueState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class WritableQueueStateStack<E>
implements WritableQueueState<E> {
    private final WritableStatesStack writableStatesStack;
    private final String serviceName;
    private final String stateKey;

    public WritableQueueStateStack(@NonNull WritableStatesStack writableStatesStack, @NonNull String serviceName, @NonNull String stateKey) {
        this.writableStatesStack = Objects.requireNonNull(writableStatesStack, "writableStatesStack must not be null");
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName must not be null");
        this.stateKey = Objects.requireNonNull(stateKey, "stateKey must not be null");
    }

    @NonNull
    private WritableQueueState<E> getCurrent() {
        return this.writableStatesStack.getCurrent().getQueue(this.stateKey);
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NonNull
    public String getStateKey() {
        return this.stateKey;
    }

    @Nullable
    public E peek() {
        return (E)this.getCurrent().peek();
    }

    @NonNull
    public Iterator<E> iterator() {
        return this.getCurrent().iterator();
    }

    public void add(@NonNull E element) {
        this.getCurrent().add(element);
    }

    @Nullable
    public E removeIf(@NonNull Predicate<E> predicate) {
        return (E)this.getCurrent().removeIf(predicate);
    }
}

