/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.file;

import com.hedera.node.app.hapi.fees.usage.file.FileOpsUsage;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import java.nio.charset.StandardCharsets;

public class ExtantFileContext {
    private final long currentSize;
    private final long currentExpiry;
    private final String currentMemo;
    private final KeyList currentWacl;

    private ExtantFileContext(Builder builder) {
        this.currentMemo = builder.currentMemo;
        this.currentSize = builder.currentSize;
        this.currentExpiry = builder.currentExpiry;
        this.currentWacl = builder.currentWacl;
    }

    public long currentNonBaseSb() {
        return this.currentSize + (long)this.currentMemo.getBytes(StandardCharsets.UTF_8).length + (long)FeeBuilder.getAccountKeyStorageSize((Key)FileOpsUsage.asKey(this.currentWacl));
    }

    public long currentSize() {
        return this.currentSize;
    }

    public long currentExpiry() {
        return this.currentExpiry;
    }

    public String currentMemo() {
        return this.currentMemo;
    }

    public KeyList currentWacl() {
        return this.currentWacl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final int SIZE_MASK = 1;
        private static final int EXPIRY_MASK = 2;
        private static final int MEMO_MASK = 4;
        private static final int WACL_MASK = 8;
        private static final int ALL_FIELDS_MASK = 15;
        private int mask = 0;
        private long currentSize;
        private long currentExpiry;
        private String currentMemo;
        private KeyList currentWacl;

        private Builder() {
        }

        public ExtantFileContext build() {
            if (this.mask != 15) {
                throw new IllegalStateException(String.format("Field mask is %d, not %d!", this.mask, 15));
            }
            return new ExtantFileContext(this);
        }

        public Builder setCurrentSize(long currentSize) {
            this.currentSize = currentSize;
            this.mask |= 1;
            return this;
        }

        public Builder setCurrentExpiry(long currentExpiry) {
            this.currentExpiry = currentExpiry;
            this.mask |= 2;
            return this;
        }

        public Builder setCurrentMemo(String currentMemo) {
            this.currentMemo = currentMemo;
            this.mask |= 4;
            return this;
        }

        public Builder setCurrentWacl(KeyList currentWacl) {
            this.currentWacl = currentWacl;
            this.mask |= 8;
            return this;
        }
    }
}

