/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.hedera.cryptography.rpm.HistoryLibraryBridge;
import com.hedera.cryptography.rpm.ProvingAndVerifyingSnarkKeys;
import com.hedera.cryptography.rpm.SigningAndVerifyingSchnorrKeys;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Objects;
import java.util.SplittableRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoryLibraryImpl
implements HistoryLibrary {
    private static final Logger log = LogManager.getLogger(HistoryLibraryImpl.class);
    private static final SplittableRandom RANDOM = new SplittableRandom();
    private static final HistoryLibraryBridge BRIDGE = HistoryLibraryBridge.getInstance();
    private static final Supplier<ProvingAndVerifyingSnarkKeys> SNARK_KEYS = Suppliers.memoize(() -> {
        try {
            byte[] elf = HistoryLibraryBridge.loadAddressBookRotationProgram();
            return BRIDGE.snarkVerificationKey(elf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load HistoryLibrary ELF", e);
        }
    });

    @Override
    public Bytes snarkVerificationKey() {
        return Bytes.wrap((byte[])((ProvingAndVerifyingSnarkKeys)SNARK_KEYS.get()).verifyingKey());
    }

    @Override
    public SigningAndVerifyingSchnorrKeys newSchnorrKeyPair() {
        byte[] bytes = new byte[32];
        RANDOM.nextBytes(bytes);
        return BRIDGE.newSchnorrKeyPair(bytes);
    }

    @Override
    public Bytes signSchnorr(@NonNull Bytes message, @NonNull Bytes privateKey) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        return Bytes.wrap((byte[])BRIDGE.signSchnorr(message.toByteArray(), privateKey.toByteArray()));
    }

    @Override
    public boolean verifySchnorr(@NonNull Bytes signature, @NonNull Bytes message, @NonNull Bytes publicKey) {
        Objects.requireNonNull(signature);
        Objects.requireNonNull(message);
        Objects.requireNonNull(publicKey);
        return BRIDGE.verifySchnorr(signature.toByteArray(), message.toByteArray(), publicKey.toByteArray());
    }

    @Override
    public Bytes hashAddressBook(@NonNull long[] weights, @NonNull byte[][] publicKeys) {
        Objects.requireNonNull(weights);
        Objects.requireNonNull(publicKeys);
        if (weights.length != publicKeys.length) {
            throw new IllegalArgumentException("The number of weights and public keys must be the same");
        }
        return Bytes.wrap((byte[])BRIDGE.hashAddressBook(publicKeys, weights));
    }

    @Override
    public Bytes hashHintsVerificationKey(@NonNull Bytes hintsVerificationKey) {
        Objects.requireNonNull(hintsVerificationKey);
        return Bytes.wrap((byte[])BRIDGE.hashHintsVerificationKey(hintsVerificationKey.toByteArray()));
    }

    @Override
    @NonNull
    public Bytes proveChainOfTrust(@NonNull Bytes genesisAddressBookHash, @Nullable Bytes sourceProof, @NonNull long[] currentAddressBookWeights, @NonNull byte[][] currentAddressBookVerifyingKeys, @NonNull long[] nextAddressBookWeights, @NonNull byte[][] nextAddressBookVerifyingKeys, @NonNull byte[][] sourceSignatures, @NonNull Bytes targetMetadataHash) {
        Objects.requireNonNull(genesisAddressBookHash);
        Objects.requireNonNull(currentAddressBookWeights);
        Objects.requireNonNull(currentAddressBookVerifyingKeys);
        Objects.requireNonNull(nextAddressBookWeights);
        Objects.requireNonNull(nextAddressBookVerifyingKeys);
        Objects.requireNonNull(sourceSignatures);
        Objects.requireNonNull(targetMetadataHash);
        if (currentAddressBookWeights.length != currentAddressBookVerifyingKeys.length) {
            throw new IllegalArgumentException("The number of weights and verifying keys must be the same");
        }
        if (nextAddressBookWeights.length != nextAddressBookVerifyingKeys.length) {
            throw new IllegalArgumentException("The number of weights and verifying keys must be the same");
        }
        byte[] proof = BRIDGE.proveChainOfTrust(((ProvingAndVerifyingSnarkKeys)SNARK_KEYS.get()).provingKey(), ((ProvingAndVerifyingSnarkKeys)SNARK_KEYS.get()).verifyingKey(), genesisAddressBookHash.toByteArray(), currentAddressBookVerifyingKeys, currentAddressBookWeights, nextAddressBookVerifyingKeys, nextAddressBookWeights, sourceProof == null ? null : sourceProof.toByteArray(), targetMetadataHash.toByteArray(), sourceSignatures);
        Objects.requireNonNull(proof);
        return Bytes.wrap((byte[])proof);
    }

    @Override
    public boolean verifyChainOfTrust(@NonNull Bytes proof) {
        Objects.requireNonNull(proof);
        return BRIDGE.verifyChainOfTrust(((ProvingAndVerifyingSnarkKeys)SNARK_KEYS.get()).verifyingKey(), proof.toByteArray());
    }
}

