/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.ids;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.utility.CommonUtils;

public class AppEntityIdFactory
implements EntityIdFactory {
    private final long shard;
    private final long realm;

    public AppEntityIdFactory(@NonNull Configuration bootstrapConfig) {
        Objects.requireNonNull(bootstrapConfig);
        HederaConfig hederaConfig = (HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class);
        this.shard = hederaConfig.shard();
        this.realm = hederaConfig.realm();
    }

    public TokenID newTokenId(long number) {
        return new TokenID(this.shard, this.realm, number);
    }

    public TopicID newTopicId(long number) {
        return new TopicID(this.shard, this.realm, number);
    }

    public ScheduleID newScheduleId(long number) {
        return new ScheduleID(this.shard, this.realm, number);
    }

    public AccountID newAccountId(long number) {
        return AccountID.newBuilder().shardNum(this.shard).realmNum(this.realm).accountNum(number).build();
    }

    public AccountID newAccountIdWithAlias(@NonNull Bytes alias) {
        return AccountID.newBuilder().shardNum(this.shard).realmNum(this.realm).alias(alias).build();
    }

    public AccountID newDefaultAccountId() {
        return AccountID.newBuilder().shardNum(this.shard).realmNum(this.realm).build();
    }

    public FileID newFileId(long number) {
        return new FileID(this.shard, this.realm, number);
    }

    public ContractID newContractId(long number) {
        return ContractID.newBuilder().shardNum(this.shard).realmNum(this.realm).contractNum(number).build();
    }

    public ContractID newContractIdWithEvmAddress(@NonNull Bytes evmAddress) {
        return ContractID.newBuilder().shardNum(this.shard).realmNum(this.realm).evmAddress(evmAddress).build();
    }

    public String hexLongZero(long number) {
        byte[] evmAddress = new byte[20];
        byte[] shardBytes = Ints.toByteArray((int)((int)this.shard));
        byte[] realmBytes = Longs.toByteArray((long)this.realm);
        byte[] numBytes = Longs.toByteArray((long)number);
        System.arraycopy(shardBytes, 0, evmAddress, 0, 4);
        System.arraycopy(realmBytes, 0, evmAddress, 4, 8);
        System.arraycopy(numBytes, 0, evmAddress, 12, 8);
        return CommonUtils.hex((byte[])evmAddress);
    }
}

