/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.scheduled.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ScheduleInfoJsonCodec
implements JsonCodec<ScheduleInfo> {
    public static final OneOf<ScheduleInfo.DataOneOfType> DATA_UNSET = new OneOf((Enum)ScheduleInfo.DataOneOfType.UNSET, null);

    @NonNull
    public ScheduleInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ScheduleID temp_scheduleID = null;
            OneOf temp_data = DATA_UNSET;
            Timestamp temp_expirationTime = null;
            SchedulableTransactionBody temp_scheduledTransactionBody = null;
            String temp_memo = "";
            Key temp_adminKey = null;
            KeyList temp_signers = null;
            AccountID temp_creatorAccountID = null;
            AccountID temp_payerAccountID = null;
            TransactionID temp_scheduledTransactionID = null;
            Bytes temp_ledger_id = Bytes.EMPTY;
            boolean temp_wait_for_expiry = false;
            block32: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "scheduleID": {
                        temp_scheduleID = (ScheduleID)ScheduleID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "deletionTime": {
                        temp_data = new OneOf((Enum)ScheduleInfo.DataOneOfType.DELETION_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block32;
                    }
                    case "executionTime": {
                        temp_data = new OneOf((Enum)ScheduleInfo.DataOneOfType.EXECUTION_TIME, Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block32;
                    }
                    case "expirationTime": {
                        temp_expirationTime = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "scheduledTransactionBody": {
                        temp_scheduledTransactionBody = (SchedulableTransactionBody)SchedulableTransactionBody.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block32;
                    }
                    case "adminKey": {
                        temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "signers": {
                        temp_signers = (KeyList)KeyList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "creatorAccountID": {
                        temp_creatorAccountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "payerAccountID": {
                        temp_payerAccountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "scheduledTransactionID": {
                        temp_scheduledTransactionID = (TransactionID)TransactionID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block32;
                    }
                    case "ledgerId": {
                        temp_ledger_id = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block32;
                    }
                    case "waitForExpiry": {
                        temp_wait_for_expiry = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block32;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ScheduleInfo(temp_scheduleID, temp_data, temp_expirationTime, temp_scheduledTransactionBody, temp_memo, temp_adminKey, temp_signers, temp_creatorAccountID, temp_payerAccountID, temp_scheduledTransactionID, temp_ledger_id, temp_wait_for_expiry);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ScheduleInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.scheduleID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleID", ScheduleID.JSON, (Object)data.scheduleID()));
        }
        if (data.data().kind() == ScheduleInfo.DataOneOfType.DELETION_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"deletionTime", Timestamp.JSON, (Object)data.deletionTime()));
        }
        if (data.data().kind() == ScheduleInfo.DataOneOfType.EXECUTION_TIME) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"executionTime", Timestamp.JSON, (Object)data.executionTime()));
        }
        if (data.expirationTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expirationTime", Timestamp.JSON, (Object)data.expirationTime()));
        }
        if (data.scheduledTransactionBody() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduledTransactionBody", SchedulableTransactionBody.JSON, (Object)data.scheduledTransactionBody()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.signers() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"signers", KeyList.JSON, (Object)data.signers()));
        }
        if (data.creatorAccountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"creatorAccountID", AccountID.JSON, (Object)data.creatorAccountID()));
        }
        if (data.payerAccountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"payerAccountID", AccountID.JSON, (Object)data.payerAccountID()));
        }
        if (data.scheduledTransactionID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduledTransactionID", TransactionID.JSON, (Object)data.scheduledTransactionID()));
        }
        if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
        }
        if (data.waitForExpiry()) {
            fieldLines.add(JsonTools.field((String)"waitForExpiry", (boolean)data.waitForExpiry()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

