/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SubOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult subSuccess = new Operation.OperationResult(3L, null);

    public SubOperation(GasCalculator gasCalculator) {
        super(3, "SUB", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SubOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        BigInteger value1;
        BigInteger value0 = new BigInteger(1, frame.popStackItem().toArrayUnsafe());
        BigInteger result = value0.subtract(value1 = new BigInteger(1, frame.popStackItem().toArrayUnsafe()));
        byte[] resultArray = result.toByteArray();
        int length = resultArray.length;
        if (length >= 32) {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray, (int)(length - 32), (int)32));
        } else if (result.signum() < 0) {
            frame.pushStackItem((Bytes)Bytes32.leftPad((Bytes)Bytes.wrap((byte[])resultArray), (byte)-1));
        } else {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray));
        }
        return subSuccess;
    }
}

