/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform.prometheus;

import com.swirlds.common.metrics.platform.prometheus.MetricAdapter;
import com.swirlds.common.metrics.platform.prometheus.NameConverter;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metric;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.prometheus.client.SimpleCollector;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMetricAdapter
implements MetricAdapter {
    private static final Logger logger = LogManager.getLogger(AbstractMetricAdapter.class);
    protected final PrometheusEndpoint.AdapterType adapterType;
    @NonNull
    private final AdaptedMetricCommonValues values;
    private final AtomicInteger referenceCount = new AtomicInteger();

    protected AbstractMetricAdapter(@NonNull PrometheusEndpoint.AdapterType adapterType, @NonNull Metric metric) {
        this(adapterType, metric, true);
    }

    protected AbstractMetricAdapter(@NonNull PrometheusEndpoint.AdapterType adapterType, @NonNull Metric metric, boolean supportsUnit) {
        this.adapterType = Objects.requireNonNull(adapterType, "adapterType must not be null");
        this.values = new AdaptedMetricCommonValues(metric, supportsUnit);
    }

    @NonNull
    protected final <C extends SimpleCollector<?>, T extends SimpleCollector.Builder<T, C>> T assignCommonValues(@NonNull SimpleCollector.Builder<T, C> collectorBuilder) {
        return this.values.assignTo(collectorBuilder);
    }

    @Override
    public int incAndGetReferenceCount() {
        return this.referenceCount.incrementAndGet();
    }

    @Override
    public int decAndGetReferenceCount() {
        return this.referenceCount.decrementAndGet();
    }

    private static class AdaptedMetricCommonValues {
        private final boolean supportsUnit;
        @NonNull
        private final String subSystem;
        @NonNull
        private final String name;
        @NonNull
        private final String unit;
        @NonNull
        private final String help;

        private AdaptedMetricCommonValues(@NonNull Metric metric, boolean supportsUnit) {
            Objects.requireNonNull(metric, "metric must not be null");
            this.supportsUnit = supportsUnit;
            this.subSystem = NameConverter.fix(metric.getCategory());
            this.name = NameConverter.fix(metric.getName());
            this.unit = NameConverter.fix(metric.getUnit());
            this.help = metric.getDescription();
            this.verifyMetricNamingComponents(metric);
        }

        @NonNull
        <C extends SimpleCollector<?>, T extends SimpleCollector.Builder<T, C>> T assignTo(@NonNull SimpleCollector.Builder<T, C> collectorBuilder) {
            SimpleCollector.Builder builder = collectorBuilder.subsystem(this.subSystem).name(this.name).help(this.help);
            return (T)(this.supportsUnit ? builder.unit(this.unit) : builder);
        }

        private void verifyMetricNamingComponents(@NonNull Metric metric) {
            if (!Objects.equals(this.subSystem, metric.getCategory())) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "category field changed for metric:{} from:{} to:{}", (Object)metric, (Object)metric.getCategory(), (Object)this.subSystem);
            }
            if (!Objects.equals(this.name, metric.getName())) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "name field changed for metric:{} from:{} to:{}", (Object)metric, (Object)metric.getName(), (Object)this.name);
            }
            if (this.supportsUnit && !Objects.equals(this.unit, metric.getUnit())) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "unit field changed for metric:{} from:{} to:{}", (Object)metric, (Object)metric.getUnit(), (Object)this.unit);
            }
        }
    }
}

