/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.ethereum;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.BaseUInt256Value;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Wei;

public final class Gas
extends BaseUInt256Value<Gas> {
    private static final int MAX_CONSTANT = 64;
    private static final BigInteger BI_MAX_CONSTANT = BigInteger.valueOf(64L);
    private static final UInt256 UINT256_MAX_CONSTANT = UInt256.valueOf(64L);
    private static final Gas[] CONSTANTS = new Gas[65];
    public static final Gas ZERO;
    public static final Gas MAX;

    private Gas(UInt256 bytes) {
        super(bytes, Gas::new);
    }

    private Gas(long value) {
        super(value, Gas::new);
    }

    public static Gas valueOf(UInt256 value) {
        if (value.compareTo((Bytes)UINT256_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        return new Gas(value);
    }

    public static Gas valueOf(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        if (value <= 64L) {
            return CONSTANTS[(int)value];
        }
        return new Gas(value);
    }

    public static Gas valueOf(BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        if (value.compareTo(BI_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        return new Gas(UInt256.valueOf(value));
    }

    public static Gas minimum(Gas one, Gas two) {
        return one.compareTo((Bytes)two) <= 0 ? one : two;
    }

    public Wei priceFor(Wei gasPrice) {
        return Wei.valueOf(gasPrice.toUInt256().multiply(this.toUInt256()));
    }

    public boolean tooHigh() {
        return this.greaterThan(MAX);
    }

    static {
        Gas.CONSTANTS[0] = new Gas(UInt256.ZERO);
        for (int i = 1; i <= 64; ++i) {
            Gas.CONSTANTS[i] = new Gas(i);
        }
        ZERO = Gas.valueOf(0L);
        MAX = Gas.valueOf(Long.MAX_VALUE);
    }
}

