/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorizedraw;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.node.app.service.contract.impl.annotations.ServicesV051;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorizedraw.IsAuthorizedRawCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsAuthorizedRawTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod IS_AUTHORIZED_RAW = SystemContractMethod.declare("isAuthorizedRaw(address,bytes,bytes)", "(bool)").withCategories(SystemContractMethod.Category.IS_AUTHORIZED);
    private static final int ADDRESS_ARG = 0;
    private static final int HASH_ARG = 1;
    private static final int SIGNATURE_ARG = 2;
    private final CustomGasCalculator customGasCalculator;

    @Inject
    public IsAuthorizedRawTranslator(@ServicesV051 @NonNull FeatureFlags featureFlags, @NonNull CustomGasCalculator customGasCalculator, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        Objects.requireNonNull(featureFlags, "featureFlags");
        this.customGasCalculator = Objects.requireNonNull(customGasCalculator);
        this.registerMethods(IS_AUTHORIZED_RAW);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        boolean callEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractAccountServiceIsAuthorizedRawEnabled();
        if (attempt.isSelectorIfConfigEnabled(callEnabled, IS_AUTHORIZED_RAW)) {
            return Optional.of(IS_AUTHORIZED_RAW);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        if (attempt.isSelector(IS_AUTHORIZED_RAW)) {
            Tuple call = IS_AUTHORIZED_RAW.decodeCall(attempt.inputBytes());
            Address address = (Address)call.get(0);
            byte[] messageHash = (byte[])call.get(1);
            byte[] signature = (byte[])call.get(2);
            return new IsAuthorizedRawCall(attempt, address, messageHash, signature, this.customGasCalculator);
        }
        return null;
    }
}

