/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.permits;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;

public class SyncPermitMetrics {
    private static final IntegerGauge.Config PERMITS_AVAILABLE_CONFIG = new IntegerGauge.Config("platform", "syncPermitsAvailable").withDescription("number of sync permits available");
    private final IntegerGauge permitsAvailable;
    private static final IntegerGauge.Config REVOKED_PERMITS_CONFIG = new IntegerGauge.Config("platform", "syncPermitsRevoked").withDescription("number of sync permits revoked");
    private final IntegerGauge revokedPermits;
    private static final IntegerGauge.Config UTILIZED_PERMITS_CONFIG = new IntegerGauge.Config("platform", "syncPermitsUtilized").withDescription("number of sync permits utilized");
    private final IntegerGauge utilizedPermits;

    public SyncPermitMetrics(@NonNull PlatformContext platformContext) {
        this.permitsAvailable = (IntegerGauge)platformContext.getMetrics().getOrCreate((MetricConfig)PERMITS_AVAILABLE_CONFIG);
        this.revokedPermits = (IntegerGauge)platformContext.getMetrics().getOrCreate((MetricConfig)REVOKED_PERMITS_CONFIG);
        this.utilizedPermits = (IntegerGauge)platformContext.getMetrics().getOrCreate((MetricConfig)UTILIZED_PERMITS_CONFIG);
    }

    public void reportPermits(int permitsAvailable, int permitsRevoked, int permitsUsed) {
        this.permitsAvailable.set(permitsAvailable);
        this.revokedPermits.set(permitsRevoked);
        this.utilizedPermits.set(permitsUsed);
    }
}

