/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.states;

import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.NegotiationStateWithDescription;
import com.swirlds.platform.network.communication.states.SentInitiate;
import com.swirlds.platform.network.communication.states.SentKeepalive;
import java.io.IOException;
import java.io.OutputStream;

public class InitialState
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final OutputStream byteOutput;
    private final SentKeepalive stateSentKeepalive;
    private final SentInitiate stateSentInitiate;

    public InitialState(NegotiationProtocols protocols, OutputStream byteOutput, SentKeepalive stateSentKeepalive, SentInitiate stateSentInitiate) {
        this.protocols = protocols;
        this.byteOutput = byteOutput;
        this.stateSentKeepalive = stateSentKeepalive;
        this.stateSentInitiate = stateSentInitiate;
    }

    @Override
    public NegotiationState transition() throws IOException {
        byte protocolByte = this.protocols.initiateProtocol();
        if (protocolByte >= 0) {
            this.byteOutput.write(protocolByte);
            this.byteOutput.flush();
            this.setDescription("initiated protocol " + this.protocols.getInitiatedProtocol().getProtocolName());
            return this.stateSentInitiate.initiatedProtocol(protocolByte);
        }
        this.byteOutput.write(255);
        this.byteOutput.flush();
        this.setDescription("sent keepalive");
        return this.stateSentKeepalive;
    }
}

