/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config;

import com.hedera.node.config.NetworkProperty;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.reflection.ConfigReflectionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Utils {
    private static final Logger logger = LogManager.getLogger(Utils.class);

    private Utils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static SortedMap<String, Object> networkProperties(@NonNull Configuration configuration) {
        return Utils.filteredProperties(configuration, component -> component.getAnnotation(NetworkProperty.class) != null);
    }

    public static SortedMap<String, Object> allProperties(@NonNull Configuration configuration) {
        return Utils.filteredProperties(configuration, component -> true);
    }

    private static SortedMap<String, Object> filteredProperties(@NonNull Configuration configuration, @NonNull Predicate<RecordComponent> filter) {
        TreeMap recordProperties = new TreeMap();
        configuration.getConfigDataTypes().forEach(configDataType -> {
            String propertyNamePrefix = ConfigReflectionUtils.getNamePrefixForConfigDataRecord((AnnotatedElement)configDataType);
            Arrays.stream(configDataType.getRecordComponents()).filter(filter).forEach(component -> {
                String name = ConfigReflectionUtils.getPropertyNameForConfigDataProperty((String)propertyNamePrefix, (RecordComponent)component);
                Record configData = configuration.getConfigData(configDataType);
                try {
                    recordProperties.put(name, component.getAccessor().invoke((Object)configData, new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to load config property value for {}", (Object)name, (Object)e);
                }
            });
        });
        return Collections.unmodifiableSortedMap(recordProperties);
    }

    public static int maxIngestParseSize(Configuration configuration) {
        boolean jumboTxnEnabled = ((JumboTransactionsConfig)configuration.getConfigData(JumboTransactionsConfig.class)).isEnabled();
        int jumboMaxTxnSize = ((JumboTransactionsConfig)configuration.getConfigData(JumboTransactionsConfig.class)).maxTxnSize();
        int transactionMaxBytes = ((HederaConfig)configuration.getConfigData(HederaConfig.class)).transactionMaxBytes();
        return jumboTxnEnabled ? jumboMaxTxnSize : transactionMaxBytes;
    }
}

