/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractTask
extends ForkJoinTask<Void> {
    private final AtomicInteger dependencyCount;
    private final ForkJoinPool pool;

    protected AbstractTask(@NonNull ForkJoinPool pool, int dependencyCount) {
        this.pool = pool;
        this.dependencyCount = dependencyCount > 0 ? new AtomicInteger(dependencyCount) : null;
    }

    @Override
    public final Void getRawResult() {
        return null;
    }

    @Override
    protected final void setRawResult(Void value) {
    }

    public void send() {
        if (this.dependencyCount == null || this.dependencyCount.decrementAndGet() == 0) {
            ForkJoinWorkerThread t;
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread && (t = (ForkJoinWorkerThread)thread).getPool() == this.pool) {
                this.fork();
            } else {
                this.pool.execute(this);
            }
        }
    }

    @Override
    protected final boolean exec() {
        try {
            return this.onExecute();
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
            return false;
        }
    }

    protected abstract boolean onExecute() throws Exception;

    @Override
    public final void completeExceptionally(Throwable t) {
        super.completeExceptionally(t);
        this.onException(t);
    }

    protected void onException(Throwable t) {
    }
}

