/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.workflows;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.NoopFeeCharging;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public record DispatchOptions<T extends StreamBuilder>(@NonNull Commit commit, @NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull UsePresetTxnId usePresetTxnId, @NonNull Predicate<Key> keyVerifier, @NonNull Set<Key> authorizingKeys, @NonNull HandleContext.TransactionCategory category, @NonNull HandleContext.ConsensusThrottling throttling, @NonNull Class<T> streamBuilderType, @NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull StreamBuilder.SignedTxCustomizer signedTxCustomizer, @NonNull HandleContext.DispatchMetadata dispatchMetadata, @Nullable FeeCharging customFeeCharging) {
    private static final Predicate<Key> PREAUTHORIZED_KEYS = k -> true;
    private static final Predicate<Key> NO_AUTHORIZED_KEYS = k -> false;

    public DispatchOptions {
        Objects.requireNonNull(commit);
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(body);
        Objects.requireNonNull(usePresetTxnId);
        Objects.requireNonNull(keyVerifier);
        Objects.requireNonNull(category);
        Objects.requireNonNull(throttling);
        Objects.requireNonNull(authorizingKeys);
        Objects.requireNonNull(streamBuilderType);
        Objects.requireNonNull(reversingBehavior);
        Objects.requireNonNull(signedTxCustomizer);
        Objects.requireNonNull(dispatchMetadata);
    }

    @Nullable
    public Predicate<Key> effectiveKeyVerifier() {
        return this.keyVerifier == PREAUTHORIZED_KEYS ? null : this.keyVerifier;
    }

    public boolean commitImmediately() {
        return this.commit == Commit.IMMEDIATELY;
    }

    public static <T extends StreamBuilder> DispatchOptions<T> independentDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Class<T> streamBuilderType) {
        return new DispatchOptions<T>(Commit.IMMEDIATELY, payerId, body, UsePresetTxnId.NO, PREAUTHORIZED_KEYS, Collections.emptySet(), HandleContext.TransactionCategory.PRECEDING, HandleContext.ConsensusThrottling.OFF, streamBuilderType, StreamBuilder.ReversingBehavior.IRREVERSIBLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, HandleContext.DispatchMetadata.EMPTY_METADATA, NoopFeeCharging.NOOP_FEE_CHARGING);
    }

    public static <T extends StreamBuilder> DispatchOptions<T> setupDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Class<T> streamBuilderType, @Nullable FeeCharging customFeeCharging) {
        return new DispatchOptions<T>(Commit.WITH_PARENT, payerId, body, UsePresetTxnId.NO, PREAUTHORIZED_KEYS, Collections.emptySet(), HandleContext.TransactionCategory.PRECEDING, HandleContext.ConsensusThrottling.ON, streamBuilderType, StreamBuilder.ReversingBehavior.REMOVABLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, HandleContext.DispatchMetadata.EMPTY_METADATA, customFeeCharging);
    }

    public static <T extends StreamBuilder> DispatchOptions<T> subDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Predicate<Key> keyVerifier, @NonNull Set<Key> authorizingKeys, @NonNull Class<T> streamBuilderType, @NonNull StakingRewards stakingRewards, @NonNull UsePresetTxnId usePresetTxnId, @NonNull FeeCharging customFeeCharging, @NonNull PropagateFeeChargingStrategy propagateFeeChargingStrategy) {
        Objects.requireNonNull(customFeeCharging);
        Objects.requireNonNull(propagateFeeChargingStrategy);
        HandleContext.TransactionCategory category = switch (Objects.requireNonNull(stakingRewards).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> HandleContext.TransactionCategory.SCHEDULED;
            case 1 -> HandleContext.TransactionCategory.CHILD;
        };
        HandleContext.DispatchMetadata metadata = switch (propagateFeeChargingStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new HandleContext.DispatchMetadata(HandleContext.DispatchMetadata.Type.CUSTOM_FEE_CHARGING, customFeeCharging);
            case 1 -> HandleContext.DispatchMetadata.EMPTY_METADATA;
        };
        return new DispatchOptions<T>(Commit.WITH_PARENT, payerId, body, usePresetTxnId, keyVerifier, authorizingKeys, category, HandleContext.ConsensusThrottling.ON, streamBuilderType, StreamBuilder.ReversingBehavior.REVERSIBLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, metadata, customFeeCharging);
    }

    public static <T extends StreamBuilder> DispatchOptions<T> stepDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Class<T> streamBuilderType, @NonNull StreamBuilder.SignedTxCustomizer signedTxCustomizer) {
        return new DispatchOptions<T>(Commit.WITH_PARENT, payerId, body, UsePresetTxnId.NO, PREAUTHORIZED_KEYS, Collections.emptySet(), HandleContext.TransactionCategory.CHILD, HandleContext.ConsensusThrottling.OFF, streamBuilderType, StreamBuilder.ReversingBehavior.REMOVABLE, signedTxCustomizer, HandleContext.DispatchMetadata.EMPTY_METADATA, NoopFeeCharging.NOOP_FEE_CHARGING);
    }

    public static <T extends StreamBuilder> DispatchOptions<T> stepDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Class<T> streamBuilderType, @NonNull StreamBuilder.SignedTxCustomizer signedTxCustomizer, @NonNull HandleContext.DispatchMetadata metaData) {
        return new DispatchOptions<T>(Commit.WITH_PARENT, payerId, body, UsePresetTxnId.NO, PREAUTHORIZED_KEYS, Collections.emptySet(), HandleContext.TransactionCategory.CHILD, HandleContext.ConsensusThrottling.OFF, streamBuilderType, StreamBuilder.ReversingBehavior.REMOVABLE, signedTxCustomizer, metaData, NoopFeeCharging.NOOP_FEE_CHARGING);
    }

    public static <T extends StreamBuilder> DispatchOptions<T> atomicBatchDispatch(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull Class<T> streamBuilderType, @NonNull FeeCharging customFeeCharging, @NonNull HandleContext.DispatchMetadata innerTransactionBytes) {
        return new DispatchOptions<T>(Commit.WITH_PARENT, payerId, body, UsePresetTxnId.NO, NO_AUTHORIZED_KEYS, Collections.emptySet(), HandleContext.TransactionCategory.BATCH_INNER, HandleContext.ConsensusThrottling.ON, streamBuilderType, StreamBuilder.ReversingBehavior.REVERSIBLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, innerTransactionBytes, customFeeCharging);
    }

    public static enum Commit {
        WITH_PARENT,
        IMMEDIATELY;

    }

    public static enum UsePresetTxnId {
        YES,
        NO;

    }

    public static enum StakingRewards {
        ON,
        OFF;

    }

    public static enum PropagateFeeChargingStrategy {
        YES,
        NO;

    }
}

