/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.state.token.Account;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public enum StakeIdChangeType {
    FROM_ABSENT_TO_NODE{

        @Override
        boolean awardsToNode() {
            return true;
        }
    }
    ,
    FROM_ACCOUNT_TO_NODE{

        @Override
        boolean withdrawsFromAccount() {
            return true;
        }

        @Override
        boolean awardsToNode() {
            return true;
        }
    }
    ,
    FROM_NODE_TO_NODE{

        @Override
        boolean withdrawsFromNode() {
            return true;
        }

        @Override
        boolean awardsToNode() {
            return true;
        }
    }
    ,
    FROM_ABSENT_TO_ACCOUNT{

        @Override
        boolean awardsToAccount() {
            return true;
        }
    }
    ,
    FROM_NODE_TO_ACCOUNT{

        @Override
        boolean withdrawsFromNode() {
            return true;
        }

        @Override
        boolean awardsToAccount() {
            return true;
        }
    }
    ,
    FROM_ACCOUNT_TO_ACCOUNT{

        @Override
        boolean withdrawsFromAccount() {
            return true;
        }

        @Override
        boolean awardsToAccount() {
            return true;
        }
    }
    ,
    FROM_ABSENT_TO_ABSENT{}
    ,
    FROM_ACCOUNT_TO_ABSENT{

        @Override
        boolean withdrawsFromAccount() {
            return true;
        }
    }
    ,
    FROM_NODE_TO_ABSENT{

        @Override
        boolean withdrawsFromNode() {
            return true;
        }
    };


    public static StakeIdChangeType forCase(@Nullable Account currentAccount, @NonNull Account modifiedAccount) {
        Account.StakedIdOneOfType curStakedIdCase = currentAccount == null ? Account.StakedIdOneOfType.UNSET : StakeIdChangeType.getCurrentStakedIdCase(currentAccount);
        Account.StakedIdOneOfType newStakedIdCase = StakeIdChangeType.getCurrentStakedIdCase(modifiedAccount);
        if (newStakedIdCase.equals((Object)Account.StakedIdOneOfType.STAKED_NODE_ID)) {
            if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.UNSET)) {
                return FROM_ABSENT_TO_NODE;
            }
            if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID)) {
                return FROM_ACCOUNT_TO_NODE;
            }
            return FROM_NODE_TO_NODE;
        }
        if (newStakedIdCase.equals((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID)) {
            if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.UNSET)) {
                return FROM_ABSENT_TO_ACCOUNT;
            }
            if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID)) {
                return FROM_ACCOUNT_TO_ACCOUNT;
            }
            return FROM_NODE_TO_ACCOUNT;
        }
        if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.UNSET)) {
            return FROM_ABSENT_TO_ABSENT;
        }
        if (curStakedIdCase.equals((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID)) {
            return FROM_ACCOUNT_TO_ABSENT;
        }
        return FROM_NODE_TO_ABSENT;
    }

    private static Account.StakedIdOneOfType getCurrentStakedIdCase(Account account) {
        Account.StakedIdOneOfType kind = (Account.StakedIdOneOfType)account.stakedId().kind();
        if (kind.equals((Object)Account.StakedIdOneOfType.STAKED_NODE_ID)) {
            return account.stakedNodeIdOrElse(Long.valueOf(-1L)) == -1L ? Account.StakedIdOneOfType.UNSET : Account.StakedIdOneOfType.STAKED_NODE_ID;
        }
        if (kind.equals((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID)) {
            return account.stakedAccountId() == null ? Account.StakedIdOneOfType.UNSET : Account.StakedIdOneOfType.STAKED_ACCOUNT_ID;
        }
        return Account.StakedIdOneOfType.UNSET;
    }

    boolean withdrawsFromNode() {
        return false;
    }

    boolean withdrawsFromAccount() {
        return false;
    }

    boolean awardsToNode() {
        return false;
    }

    boolean awardsToAccount() {
        return false;
    }
}

