/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class AllowanceValidator {
    @Inject
    public AllowanceValidator() {
    }

    protected void validateTotalAllowancesPerTxn(int totalAllowances, @NonNull HederaConfig hederaConfig) {
        HandleException.validateFalse((totalAllowances > hederaConfig.allowancesMaxTransactionLimit() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ALLOWANCES_EXCEEDED);
    }

    protected void validateSerialNums(List<Long> serialNums, TokenID tokenId, ReadableNftStore nftStore) {
        HashSet<Long> serialsSet = new HashSet<Long>(serialNums);
        for (Long serial : serialsSet) {
            HandleException.validateTrue((serial > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
            Nft nft = nftStore.get(tokenId, serial.longValue());
            HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
        }
    }

    public static int aggregateApproveNftAllowances(List<NftAllowance> nftAllowances) {
        int nftAllowancesTotal = 0;
        for (NftAllowance allowances : nftAllowances) {
            if (!allowances.serialNumbers().isEmpty()) {
                nftAllowancesTotal += allowances.serialNumbers().size();
                continue;
            }
            ++nftAllowancesTotal;
        }
        return nftAllowancesTotal;
    }

    public static void validateAllowanceLimit(Account owner, int allowanceMaxAccountLimit) {
        int totalAllowances = owner.cryptoAllowances().size() + owner.tokenAllowances().size() + owner.approveForAllNftAllowances().size();
        HandleException.validateFalse((totalAllowances > allowanceMaxAccountLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ALLOWANCES_EXCEEDED);
    }

    public static boolean isValidOwner(@NonNull Nft nft, @NonNull AccountID ownerID, @NonNull Token token) {
        Objects.requireNonNull(nft);
        Objects.requireNonNull(ownerID);
        Objects.requireNonNull(token);
        if (nft.hasOwnerId()) {
            return nft.ownerId().equals((Object)ownerID);
        }
        return ownerID.equals((Object)token.treasuryAccountId());
    }

    public static Account getEffectiveOwner(@Nullable AccountID owner, @NonNull Account payer, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator) {
        if (owner == null || owner.accountNumOrElse(Long.valueOf(0L)) == 0L || owner.equals((Object)payer.accountId())) {
            return payer;
        }
        return TokenHandlerHelper.getIfUsable(owner, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID, TokenHandlerHelper.AccountIDType.NOT_ALIASED_ID);
    }
}

