/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class TokenSupplyChangeOpsValidator {
    @Inject
    public TokenSupplyChangeOpsValidator() {
    }

    public void validateMint(long fungibleCount, List<Bytes> metaDataList, TokensConfig tokensConfig) {
        int numNfts = metaDataList.size();
        this.validateCommon(fungibleCount, numNfts, TokensConfig::nftsMaxBatchSizeMint, tokensConfig);
        int maxNftMetadataBytes = tokensConfig.nftsMaxMetadataBytes();
        if (fungibleCount <= 0L && numNfts > 0) {
            this.validateMetaData(metaDataList, maxNftMetadataBytes);
        }
    }

    public void validateBurn(long fungibleCount, @NonNull List<Long> nftSerialNums, @NonNull TokensConfig tokensConfig) {
        this.validateCommon(fungibleCount, nftSerialNums.size(), TokensConfig::nftsMaxBatchSizeBurn, tokensConfig);
    }

    public static void verifyTokenInstanceAmounts(long fungibleAmount, @NonNull List<Long> serialNums, boolean hasToken, @NonNull ResponseCodeEnum invalidAmountResponseCode) throws PreCheckException {
        PreCheckException.validateTruePreCheck((boolean)hasToken, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateFalsePreCheck((fungibleAmount > 0L && !serialNums.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        PreCheckException.validateFalsePreCheck((fungibleAmount < 0L ? 1 : 0) != 0, (ResponseCodeEnum)invalidAmountResponseCode);
        if (fungibleAmount < 1L && !serialNums.isEmpty()) {
            for (Long serialNumber : serialNums) {
                PreCheckException.validateTruePreCheck((serialNumber > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            }
        }
    }

    public void validateWipe(long fungibleCount, @NonNull List<Long> nftSerialNums, @NonNull TokensConfig tokensConfig) {
        this.validateCommon(fungibleCount, nftSerialNums.size(), TokensConfig::nftsMaxBatchSizeWipe, tokensConfig);
    }

    private void validateCommon(long fungibleCount, int nftCount, @NonNull ToIntFunction<TokensConfig> batchSizeGetter, TokensConfig tokensConfig) {
        int maxNftBatchOpSize = batchSizeGetter.applyAsInt(tokensConfig);
        this.validateCounts(nftCount, fungibleCount, maxNftBatchOpSize);
    }

    private void validateCounts(int nftCount, long fungibleCount, long maxBatchSize) {
        if (fungibleCount <= 0L && nftCount > 0) {
            HandleException.validateTrue(((long)nftCount <= maxBatchSize ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED);
        }
    }

    private void validateMetaData(List<Bytes> metaDataList, int maxNftMetadataBytes) {
        for (Bytes bytes : metaDataList) {
            HandleException.validateTrue((bytes.toByteArray().length <= maxNftMetadataBytes ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.METADATA_TOO_LONG);
        }
    }
}

