/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.blocks.BlockItemsTranslator;
import com.hedera.node.app.blocks.impl.BlockStreamBuilder;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.records.RecordSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class BlockRecordSource
implements RecordSource {
    private final BlockItemsTranslator blockItemsTranslator;
    private final List<BlockStreamBuilder.Output> outputs;
    @Nullable
    private List<TransactionRecord> computedRecords;
    @Nullable
    private List<RecordSource.IdentifiedReceipt> computedReceipts;

    public BlockRecordSource(@NonNull List<BlockStreamBuilder.Output> outputs) {
        this(BlockItemsTranslator.BLOCK_ITEMS_TRANSLATOR, outputs);
    }

    @VisibleForTesting
    public BlockRecordSource(@NonNull BlockItemsTranslator blockItemsTranslator, @NonNull List<BlockStreamBuilder.Output> outputs) {
        this.blockItemsTranslator = Objects.requireNonNull(blockItemsTranslator);
        this.outputs = Objects.requireNonNull(outputs);
    }

    public void forEachItem(@NonNull Consumer<BlockItem> action) {
        Objects.requireNonNull(action);
        this.outputs.forEach(output -> output.forEachItem(action));
    }

    public List<RecordSource.IdentifiedReceipt> identifiedReceipts() {
        return this.computedReceipts();
    }

    public void forEachTxnRecord(@NonNull Consumer<TransactionRecord> action) {
        Objects.requireNonNull(action);
        this.computedRecords().forEach(action);
    }

    public TransactionReceipt receiptOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        for (RecordSource.IdentifiedReceipt receipt : this.computedReceipts()) {
            if (!txnId.equals((Object)receipt.txnId())) continue;
            return receipt.receipt();
        }
        throw new IllegalArgumentException();
    }

    public List<TransactionReceipt> childReceiptsOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        ArrayList<TransactionReceipt> receipts = new ArrayList<TransactionReceipt>();
        for (RecordSource.IdentifiedReceipt receipt : this.computedReceipts()) {
            if (!RecordCache.isChild((TransactionID)txnId, (TransactionID)receipt.txnId())) continue;
            receipts.add(receipt.receipt());
        }
        return receipts;
    }

    private List<RecordSource.IdentifiedReceipt> computedReceipts() {
        if (this.computedReceipts == null) {
            ArrayList<RecordSource.IdentifiedReceipt> computation = new ArrayList<RecordSource.IdentifiedReceipt>();
            for (BlockStreamBuilder.Output output : this.outputs) {
                computation.add(output.toIdentifiedReceipt(this.blockItemsTranslator));
            }
            this.computedReceipts = computation;
        }
        return this.computedReceipts;
    }

    private List<TransactionRecord> computedRecords() {
        if (this.computedRecords == null) {
            ArrayList<TransactionRecord> computation = new ArrayList<TransactionRecord>();
            for (BlockStreamBuilder.Output output : this.outputs) {
                computation.add(output.toRecord(this.blockItemsTranslator));
            }
            this.computedRecords = computation;
        }
        return this.computedRecords;
    }
}

