/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.utils.SynthTxnUtils;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.token.records.CryptoCreateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.NoopFeeCharging;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.hyperledger.besu.evm.frame.MessageFrame;

@TransactionScope
public class HandleHederaNativeOperations
implements HederaNativeOperations {
    private final HandleContext context;
    @Nullable
    private final Key maybeEthSenderKey;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public HandleHederaNativeOperations(@NonNull HandleContext context, @Nullable Key maybeEthSenderKey, @NonNull EntityIdFactory entityIdFactory) {
        this.context = Objects.requireNonNull(context);
        this.maybeEthSenderKey = maybeEthSenderKey;
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    @Override
    @NonNull
    public ReadableNftStore readableNftStore() {
        return (ReadableNftStore)this.context.storeFactory().readableStore(ReadableNftStore.class);
    }

    @Override
    @NonNull
    public ReadableTokenRelationStore readableTokenRelationStore() {
        return (ReadableTokenRelationStore)this.context.storeFactory().readableStore(ReadableTokenRelationStore.class);
    }

    @Override
    @NonNull
    public ReadableTokenStore readableTokenStore() {
        return (ReadableTokenStore)this.context.storeFactory().readableStore(ReadableTokenStore.class);
    }

    @Override
    @NonNull
    public ReadableAccountStore readableAccountStore() {
        return (ReadableAccountStore)this.context.storeFactory().readableStore(ReadableAccountStore.class);
    }

    @Override
    @NonNull
    public ReadableScheduleStore readableScheduleStore() {
        return (ReadableScheduleStore)this.context.storeFactory().readableStore(ReadableScheduleStore.class);
    }

    @Override
    public void setNonce(long contractNumber, long nonce) {
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        HederaConfig hederaConfig = (HederaConfig)this.context.configuration().getConfigData(HederaConfig.class);
        tokenServiceApi.setNonce(AccountID.newBuilder().shardNum(hederaConfig.shard()).realmNum(hederaConfig.realm()).accountNum(contractNumber).build(), nonce);
    }

    @Override
    @NonNull
    public ResponseCodeEnum createHollowAccount(@NonNull Bytes evmAddress) {
        boolean unlimitedAutoAssociations = ((EntitiesConfig)this.context.configuration().getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled();
        TransactionBody synthTxn = TransactionBody.newBuilder().cryptoCreateAccount(SynthTxnUtils.synthHollowAccountCreation(evmAddress, unlimitedAutoAssociations)).build();
        try {
            return ((CryptoCreateStreamBuilder)this.context.dispatch(DispatchOptions.setupDispatch((AccountID)this.context.payer(), (TransactionBody)synthTxn, CryptoCreateStreamBuilder.class, (FeeCharging)NoopFeeCharging.NOOP_FEE_CHARGING))).status();
        }
        catch (HandleException e) {
            return e.getStatus();
        }
    }

    @Override
    public void finalizeHollowAccountAsContract(@NonNull Bytes evmAddress) {
        Objects.requireNonNull(evmAddress);
        ReadableAccountStore accountStore = (ReadableAccountStore)this.context.storeFactory().readableStore(ReadableAccountStore.class);
        HederaConfig config = (HederaConfig)this.context.configuration().getConfigData(HederaConfig.class);
        AccountID hollowAccountId = Objects.requireNonNull(accountStore.getAccountIDByAlias(config.shard(), config.realm(), evmAddress));
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.finalizeHollowAccountAsContract(hollowAccountId);
    }

    @Override
    public boolean canScheduleContractCall(long expiry, long gasLimit, @NonNull AccountID payerId) {
        Objects.requireNonNull(payerId);
        ScheduleServiceApi scheduleServiceApi = (ScheduleServiceApi)this.context.storeFactory().serviceApi(ScheduleServiceApi.class);
        return scheduleServiceApi.hasContractCallCapacity(expiry, this.context.consensusNow(), gasLimit, payerId);
    }

    @Override
    @NonNull
    public ResponseCodeEnum transferWithReceiverSigCheck(long amount, AccountID fromEntityId, AccountID toEntityId, @NonNull VerificationStrategy strategy) {
        Account to = Objects.requireNonNull(this.getAccount(toEntityId));
        Predicate<Key> signatureTest = strategy.asSignatureTestIn(this.context, this.maybeEthSenderKey);
        if (to.receiverSigRequired() && !signatureTest.test(to.keyOrThrow())) {
            return ResponseCodeEnum.INVALID_SIGNATURE;
        }
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        tokenServiceApi.transferFromTo(fromEntityId, toEntityId, amount);
        return ResponseCodeEnum.OK;
    }

    @Override
    public void trackSelfDestructBeneficiary(AccountID deletedId, AccountID beneficiaryId, @NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        FrameUtils.selfDestructBeneficiariesFor(frame).addBeneficiaryForDeletedAccount(deletedId, beneficiaryId);
    }

    @Override
    public boolean checkForCustomFees(@NonNull CryptoTransferTransactionBody op) {
        TokenServiceApi tokenServiceApi = (TokenServiceApi)this.context.storeFactory().serviceApi(TokenServiceApi.class);
        return tokenServiceApi.checkForCustomFees(op);
    }

    @Override
    @NonNull
    public SortedSet<Key> authorizingSimpleKeys() {
        return this.context.keyVerifier().authorizingSimpleKeys();
    }

    @Override
    public TransactionID getTransactionID() {
        return this.context.body().transactionIDOrThrow();
    }

    @Override
    public EntityIdFactory entityIdFactory() {
        return this.entityIdFactory;
    }

    @Override
    public Configuration configuration() {
        return this.context.configuration();
    }
}

