/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.LogBuilder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.AbstractGrantApprovalCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.GrantApprovalTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;

public class ClassicGrantApprovalCall
extends AbstractGrantApprovalCall {
    protected static final Bytes APPROVAL_EVENT = Bytes.fromHexString((CharSequence)"8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925");

    public ClassicGrantApprovalCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID senderId, @NonNull TokenID token, @NonNull AccountID spender, long amount, @NonNull TokenType tokenType) {
        super(gasCalculator, enhancement, verificationStrategy, senderId, token, spender, amount, tokenType, false);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.tokenId == null) {
            return this.reversionWith(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.canonicalGasRequirement(DispatchType.APPROVE));
        }
        TransactionBody body = this.synthApprovalBody();
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(body, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        ResponseCodeEnum status = recordBuilder.status();
        long gasRequirement = this.gasCalculator.gasRequirement(body, DispatchType.APPROVE, this.senderId);
        if (status != ResponseCodeEnum.SUCCESS) {
            return this.reversionWith(gasRequirement, recordBuilder);
        }
        Address tokenAddress = ConversionUtils.asLongZeroAddress(this.tokenId.tokenNum());
        if (this.tokenType.equals((Object)TokenType.FUNGIBLE_COMMON)) {
            frame.addLog(this.getLogForFungibleAdjustAllowance(tokenAddress));
        } else {
            frame.addLog(this.getLogForNftAdjustAllowance(tokenAddress));
        }
        ByteBuffer encodedOutput = this.tokenType.equals((Object)TokenType.FUNGIBLE_COMMON) ? GrantApprovalTranslator.GRANT_APPROVAL.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)true)) : GrantApprovalTranslator.GRANT_APPROVAL_NFT.getOutputs().encode((Object)Tuple.singleton((Object)status.protoOrdinal()));
        return Call.PricedResult.gasOnly(FullResult.successResult(encodedOutput, gasRequirement, recordBuilder), status, false);
    }

    private Log getLogForFungibleAdjustAllowance(@NonNull Address logger) {
        return LogBuilder.logBuilder().forLogger(logger).forEventSignature(APPROVAL_EVENT).forIndexedArgument(ConversionUtils.asLongZeroAddress(this.senderId.accountNumOrThrow())).forIndexedArgument(ConversionUtils.asLongZeroAddress(this.spenderId.accountNumOrThrow())).forDataItem(this.amount).build();
    }

    private Log getLogForNftAdjustAllowance(@NonNull Address logger) {
        return LogBuilder.logBuilder().forLogger(logger).forEventSignature(APPROVAL_EVENT).forIndexedArgument(ConversionUtils.asLongZeroAddress(this.senderId.accountNumOrThrow())).forIndexedArgument(ConversionUtils.asLongZeroAddress(this.spenderId.accountNumOrThrow())).forIndexedArgument(this.amount).build();
    }
}

