/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigLeafImpl;
import io.helidon.config.ConfigListImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMissingImpl;
import io.helidon.config.ConfigObjectImpl;
import io.helidon.config.ProviderImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;

final class ConfigFactory {
    private final ConfigMapperManager mapperManager;
    private final Map<ConfigKeyImpl, ConfigNode> fullKeyToNodeMap;
    private final ConfigFilter filter;
    private final ProviderImpl provider;
    private final Function<String, List<String>> aliasGenerator;
    private final Map<PrefixedKey, AbstractConfigImpl> configCache;
    private final ReentrantReadWriteLock configCacheLock = new ReentrantReadWriteLock();
    private final Instant timestamp;

    ConfigFactory(ConfigMapperManager mapperManager, ConfigNode.ObjectNode node, ConfigFilter filter, ProviderImpl provider, Function<String, List<String>> aliasGenerator) {
        Objects.requireNonNull(mapperManager, "mapperManager argument is null.");
        Objects.requireNonNull(node, "node argument is null.");
        Objects.requireNonNull(filter, "filter argument is null.");
        Objects.requireNonNull(provider, "provider argument is null.");
        this.mapperManager = mapperManager;
        this.fullKeyToNodeMap = ConfigHelper.createFullKeyToNodeMap(node);
        this.filter = filter;
        this.provider = provider;
        this.aliasGenerator = aliasGenerator;
        this.configCache = new HashMap<PrefixedKey, AbstractConfigImpl>();
        this.timestamp = Instant.now();
    }

    Instant timestamp() {
        return this.timestamp;
    }

    AbstractConfigImpl config() {
        return this.config(ConfigKeyImpl.of(), ConfigKeyImpl.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractConfigImpl config(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        AbstractConfigImpl config;
        PrefixedKey prefixedKey = new PrefixedKey(prefix, key);
        try {
            this.configCacheLock.readLock().lock();
            config = this.configCache.get(prefixedKey);
            if (config != null) {
                AbstractConfigImpl abstractConfigImpl = config;
                return abstractConfigImpl;
            }
        }
        finally {
            this.configCacheLock.readLock().unlock();
        }
        try {
            this.configCacheLock.writeLock().lock();
            config = this.configCache.get(prefixedKey);
            if (config != null) {
                AbstractConfigImpl abstractConfigImpl = config;
                return abstractConfigImpl;
            }
            config = this.createConfig(prefix, key);
            this.configCache.put(prefixedKey, config);
            AbstractConfigImpl abstractConfigImpl = config;
            return abstractConfigImpl;
        }
        finally {
            this.configCacheLock.writeLock().unlock();
        }
    }

    private AbstractConfigImpl createConfig(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigNode value = this.findNode(prefix, key);
        if (null == value) {
            return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
        }
        switch (value.nodeType()) {
            case OBJECT: {
                return new ConfigObjectImpl(prefix, key, (ConfigNode.ObjectNode)value, this.filter, this, this.mapperManager);
            }
            case LIST: {
                return new ConfigListImpl(prefix, key, (ConfigNode.ListNode)value, this.filter, this, this.mapperManager);
            }
            case VALUE: {
                return new ConfigLeafImpl(prefix, key, (ConfigNode.ValueNode)value, this.filter, this, this.mapperManager);
            }
        }
        return new ConfigMissingImpl(prefix, key, this, this.mapperManager);
    }

    private ConfigNode findNode(ConfigKeyImpl prefix, ConfigKeyImpl key) {
        ConfigKeyImpl realKey = prefix.child(key);
        ConfigNode node = this.fullKeyToNodeMap.get(realKey);
        if (node == null && this.aliasGenerator != null) {
            String keyAlias;
            String fullKey = key.toString();
            Iterator<String> iterator = this.aliasGenerator.apply(fullKey).iterator();
            while (iterator.hasNext() && (node = this.fullKeyToNodeMap.get(prefix.child(keyAlias = iterator.next()))) == null) {
            }
        }
        if (node == null) {
            return this.provider.lazyValue(realKey.toString()).orElse(null);
        }
        return node;
    }

    Config.Context context() {
        return this.provider;
    }

    ProviderImpl provider() {
        return this.provider;
    }

    private static final class PrefixedKey {
        private final ConfigKeyImpl prefix;
        private final ConfigKeyImpl key;

        private PrefixedKey(ConfigKeyImpl prefix, ConfigKeyImpl key) {
            this.prefix = prefix;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixedKey that = (PrefixedKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.key);
        }
    }
}

