/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route.internal;

import com.swirlds.common.merkle.route.MerkleRoute;
import java.util.Iterator;

public abstract class AbstractMerkleRoute
implements MerkleRoute {
    @Override
    public final int compareTo(MerkleRoute that) {
        Iterator<Integer> iteratorA = this.iterator();
        Iterator<Integer> iteratorB = that.iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            int b;
            int a = iteratorA.next();
            if (a < (b = iteratorB.next().intValue())) {
                return -1;
            }
            if (b >= a) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public final boolean isAncestorOf(MerkleRoute that) {
        Iterator<Integer> iteratorA = this.iterator();
        Iterator<Integer> iteratorB = that.iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            int b;
            int a = iteratorA.next();
            if (a == (b = iteratorB.next().intValue())) continue;
            return false;
        }
        return !iteratorA.hasNext();
    }

    @Override
    public final boolean isDescendantOf(MerkleRoute that) {
        return that.isAncestorOf(this);
    }

    public final String toString() {
        Iterator<Integer> iterator = this.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        iterator.forEachRemaining(step -> {
            sb.append(step);
            if (iterator.hasNext()) {
                sb.append(" -> ");
            }
        });
        sb.append("]");
        return sb.toString();
    }
}

