/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.stats;

import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReconnectMapMetrics
implements ReconnectMapStats {
    private static final String RECONNECT_MAP_CATEGORY = "reconnect_vmap";
    @Nullable
    private final String originalLabel;
    private final ReconnectMapStats aggregateStats;
    private final LongGauge transfersFromTeacher;
    private final LongGauge transfersFromLearner;
    private final LongGauge internalHashes;
    private final LongGauge internalCleanHashes;
    private final LongGauge internalData;
    private final LongGauge internalCleanData;
    private final LongGauge leafHashes;
    private final LongGauge leafCleanHashes;
    private final LongGauge leafData;
    private final LongGauge leafCleanData;

    public ReconnectMapMetrics(@NonNull Metrics metrics, @Nullable String originalLabel, @Nullable ReconnectMapStats aggregateStats) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.originalLabel = originalLabel;
        this.aggregateStats = aggregateStats;
        String label = originalLabel == null ? null : originalLabel.replace('.', '_');
        this.transfersFromTeacher = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("transfersFromTeacher", label)).withDescription("number of transfers from teacher to learner"));
        this.transfersFromLearner = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("transfersFromLearner", label)).withDescription("number of transfers from learner to teacher"));
        this.internalHashes = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("internalHashes", label)).withDescription("number of internal node hashes transferred"));
        this.internalCleanHashes = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("internalCleanHashes", label)).withDescription("number of clean internal node hashes transferred"));
        this.internalData = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("internalData", label)).withDescription("number of internal node data transferred"));
        this.internalCleanData = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("internalCleanData", label)).withDescription("number of clean internal node data transferred"));
        this.leafHashes = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("leafHashes", label)).withDescription("number of leaf node hashes transferred"));
        this.leafCleanHashes = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("leafCleanHashes", label)).withDescription("number of clean leaf node hashes transferred"));
        this.leafData = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("leafData", label)).withDescription("number of leaf node data transferred"));
        this.leafCleanData = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(RECONNECT_MAP_CATEGORY, ReconnectMapMetrics.formatName("leafCleanData", label)).withDescription("number of clean leaf node data transferred"));
        this.resetMetrics();
    }

    private static String formatName(String name, String label) {
        return (String)(label == null || label.isBlank() ? name : name + "_" + label + "_") + "Total";
    }

    private static void add(LongGauge metric, long value) {
        metric.set(metric.get() + value);
    }

    private void resetMetrics() {
        this.transfersFromTeacher.set(0L);
        this.transfersFromLearner.set(0L);
        this.internalHashes.set(0L);
        this.internalCleanHashes.set(0L);
        this.internalData.set(0L);
        this.internalCleanData.set(0L);
        this.leafHashes.set(0L);
        this.leafCleanHashes.set(0L);
        this.leafData.set(0L);
        this.leafCleanData.set(0L);
    }

    @Override
    public void incrementTransfersFromTeacher() {
        ReconnectMapMetrics.add(this.transfersFromTeacher, 1L);
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementTransfersFromTeacher();
        }
    }

    @Override
    public void incrementTransfersFromLearner() {
        ReconnectMapMetrics.add(this.transfersFromLearner, 1L);
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementTransfersFromLearner();
        }
    }

    @Override
    public void incrementInternalHashes(int hashNum, int cleanHashNum) {
        if (hashNum > 0) {
            ReconnectMapMetrics.add(this.internalHashes, hashNum);
        }
        if (cleanHashNum > 0) {
            ReconnectMapMetrics.add(this.internalCleanHashes, cleanHashNum);
        }
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementInternalHashes(hashNum, cleanHashNum);
        }
    }

    @Override
    public void incrementInternalData(int dataNum, int cleanDataNum) {
        if (dataNum > 0) {
            ReconnectMapMetrics.add(this.internalData, dataNum);
        }
        if (cleanDataNum > 0) {
            ReconnectMapMetrics.add(this.internalCleanData, cleanDataNum);
        }
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementInternalData(dataNum, cleanDataNum);
        }
    }

    @Override
    public void incrementLeafHashes(int hashNum, int cleanHashNum) {
        if (hashNum > 0) {
            ReconnectMapMetrics.add(this.leafHashes, hashNum);
        }
        if (cleanHashNum > 0) {
            ReconnectMapMetrics.add(this.leafCleanHashes, cleanHashNum);
        }
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementLeafHashes(hashNum, cleanHashNum);
        }
    }

    @Override
    public void incrementLeafData(int dataNum, int cleanDataNum) {
        if (dataNum > 0) {
            ReconnectMapMetrics.add(this.leafData, dataNum);
        }
        if (cleanDataNum > 0) {
            ReconnectMapMetrics.add(this.leafCleanData, cleanDataNum);
        }
        if (this.aggregateStats != null) {
            this.aggregateStats.incrementLeafData(dataNum, cleanDataNum);
        }
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("ReconnectMapMetrics: ");
        if (this.originalLabel != null) {
            sb.append("label=").append(this.originalLabel).append("; ");
        }
        sb.append("transfersFromTeacher=").append(this.transfersFromTeacher.get()).append("; ");
        sb.append("transfersFromLearner=").append(this.transfersFromLearner.get()).append("; ");
        sb.append("internalHashes=").append(this.internalHashes.get()).append("; ");
        sb.append("internalCleanHashes=").append(this.internalCleanHashes.get()).append("; ");
        sb.append("internalData=").append(this.internalData.get()).append("; ");
        sb.append("internalCleanData=").append(this.internalCleanData.get()).append("; ");
        sb.append("leafHashes=").append(this.leafHashes.get()).append("; ");
        sb.append("leafCleanHashes=").append(this.leafCleanHashes.get()).append("; ");
        sb.append("leafData=").append(this.leafData.get()).append("; ");
        sb.append("leafCleanData=").append(this.leafCleanData.get());
        return sb.toString();
    }
}

