/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.PlatformMetrics;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.MetricsEvent;
import com.swirlds.common.metrics.platform.MetricsEventBus;
import com.swirlds.common.metrics.platform.MetricsUpdateService;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hiero.consensus.model.node.NodeId;

public class DefaultPlatformMetrics
implements PlatformMetrics {
    public static final int EXCEPTION_RATE_THRESHOLD = 10;
    @Nullable
    private final NodeId selfId;
    @NonNull
    private final MetricKeyRegistry metricKeyRegistry;
    @NonNull
    private final NavigableMap<String, Metric> metricMap = new ConcurrentSkipListMap<String, Metric>();
    @NonNull
    private final Collection<Metric> metricsView = Collections.unmodifiableCollection(this.metricMap.values());
    @NonNull
    private final Map<String, String> globalMetricKeys = new ConcurrentHashMap<String, String>();
    @NonNull
    private final PlatformMetricsFactory factory;
    @NonNull
    private final MetricsEventBus<MetricsEvent> eventBus;
    @Nullable
    private final MetricsUpdateService updateService;

    public DefaultPlatformMetrics(@Nullable NodeId selfId, @NonNull MetricKeyRegistry metricKeyRegistry, @NonNull ScheduledExecutorService executor, @NonNull PlatformMetricsFactory factory, @NonNull MetricsConfig metricsConfig) {
        this.selfId = selfId;
        this.metricKeyRegistry = Objects.requireNonNull(metricKeyRegistry, "metricsKeyRegistry must not be null");
        this.factory = Objects.requireNonNull(factory, "factory must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        this.eventBus = new MetricsEventBus(executor);
        Objects.requireNonNull(metricsConfig, "metricsConfig must not be null");
        this.updateService = metricsConfig.metricsUpdatePeriodMillis() <= 0L ? null : new MetricsUpdateService(executor, metricsConfig.metricsUpdatePeriodMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public NodeId getNodeId() {
        return this.selfId;
    }

    public Metric getMetric(@NonNull String category, @NonNull String name) {
        Objects.requireNonNull(category, "category must not be null");
        Objects.requireNonNull(name, "name must not be null");
        return (Metric)this.metricMap.get(DefaultPlatformMetrics.calculateMetricKey(category, name));
    }

    @NonNull
    public Collection<Metric> findMetricsByCategory(@NonNull String category) {
        Objects.requireNonNull(category, "category must not be null");
        String start = category + ".";
        String end = category + "/";
        return Collections.unmodifiableCollection(this.metricMap.subMap(start, end).values());
    }

    @NonNull
    public Collection<Metric> getAll() {
        return this.metricsView;
    }

    @NonNull
    public Runnable subscribe(@NonNull Consumer<? super MetricsEvent> subscriber) {
        Supplier previousEventsSupplier = () -> this.metricMap.values().stream().map(metric -> new MetricsEvent(MetricsEvent.Type.ADDED, this.selfId, (Metric)metric));
        return this.eventBus.subscribe(subscriber, previousEventsSupplier);
    }

    @NonNull
    public <T extends Metric> T getOrCreate(@NonNull MetricConfig<T, ?> config) {
        Class clazz;
        Objects.requireNonNull(config, "config must not be null");
        String key = DefaultPlatformMetrics.calculateMetricKey(config);
        Metric metric = (Metric)this.metricMap.get(key);
        if (metric == null) {
            if (!this.metricKeyRegistry.register(this.selfId, key, config.getResultClass())) {
                throw new IllegalStateException(String.format("A different metric with the category '%s' and name '%s' was already registered", config.getCategory(), config.getName()));
            }
            T newMetric = this.factory.createMetric(config);
            metric = (Metric)this.metricMap.putIfAbsent(key, (Metric)newMetric);
            if (metric == null) {
                MetricsEvent event = new MetricsEvent(MetricsEvent.Type.ADDED, this.selfId, (Metric)newMetric);
                this.eventBus.submit(event);
                return newMetric;
            }
        }
        if ((clazz = config.getResultClass()).isInstance(metric)) {
            return (T)((Metric)clazz.cast(metric));
        }
        throw new IllegalStateException("A metric with this category and name exists, but it has a different type: " + String.valueOf(metric));
    }

    public void remove(@NonNull String category, @NonNull String name) {
        Objects.requireNonNull(category, "category must not be null");
        Objects.requireNonNull(name, "name must not be null");
        String metricKey = DefaultPlatformMetrics.calculateMetricKey(category, name);
        this.throwIfGlobal(metricKey);
        Metric metric = (Metric)this.metricMap.remove(metricKey);
        if (metric != null) {
            this.metricKeyRegistry.unregister(this.selfId, metricKey);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, metric);
            this.eventBus.submit(event);
        }
    }

    public void remove(@NonNull Metric metric) {
        Objects.requireNonNull(metric, "metric must not be null");
        String metricKey = DefaultPlatformMetrics.calculateMetricKey(metric);
        this.throwIfGlobal(metricKey);
        boolean removed = this.metricMap.remove(metricKey, metric);
        if (removed) {
            this.metricKeyRegistry.unregister(this.selfId, metricKey);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, metric);
            this.eventBus.submit(event);
        }
    }

    public void remove(@NonNull MetricConfig<?, ?> config) {
        Objects.requireNonNull(config, "config must not be null");
        String metricKey = DefaultPlatformMetrics.calculateMetricKey(config);
        this.throwIfGlobal(metricKey);
        this.metricMap.computeIfPresent(metricKey, (key, oldValue) -> {
            if (!config.getResultClass().isInstance(oldValue)) {
                return oldValue;
            }
            this.metricKeyRegistry.unregister(this.selfId, (String)key);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, (Metric)oldValue);
            this.eventBus.submit(event);
            return null;
        });
    }

    private void throwIfGlobal(String metricKey) {
        if (this.globalMetricKeys.containsKey(metricKey)) {
            throw new IllegalArgumentException(String.format("Not possible to remove the global Metric (%s) from a non-global Metrics", metricKey));
        }
    }

    public void addUpdater(@NonNull Runnable updater) {
        Objects.requireNonNull(updater, "updater must not be null");
        if (this.updateService != null) {
            this.updateService.addUpdater(updater);
        }
    }

    public void removeUpdater(@NonNull Runnable updater) {
        Objects.requireNonNull(updater, "updater must not be null");
        if (this.updateService != null) {
            this.updateService.removeUpdater(updater);
        }
    }

    public void start() {
        if (this.updateService != null) {
            this.updateService.start();
        }
    }

    public boolean shutdown() throws InterruptedException {
        this.metricMap.entrySet().stream().filter(entry -> !this.globalMetricKeys.containsKey(entry.getKey())).map(entry -> new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, (Metric)entry.getValue())).forEach(this.eventBus::submit);
        return this.updateService == null || this.updateService.shutdown();
    }

    public static String calculateMetricKey(@NonNull String category, @NonNull String name) {
        return category + "." + name;
    }

    @NonNull
    public static String calculateMetricKey(@NonNull Metric metric) {
        return DefaultPlatformMetrics.calculateMetricKey(metric.getCategory(), metric.getName());
    }

    @NonNull
    public static String calculateMetricKey(@NonNull MetricConfig<?, ?> config) {
        return DefaultPlatformMetrics.calculateMetricKey(config.getCategory(), config.getName());
    }

    public void handleGlobalMetrics(@NonNull MetricsEvent event) {
        Metric metric = event.metric();
        String metricKey = DefaultPlatformMetrics.calculateMetricKey(metric);
        switch (event.type()) {
            case ADDED: {
                this.globalMetricKeys.put(metricKey, metricKey);
                this.metricMap.put(metricKey, metric);
                break;
            }
            case REMOVED: {
                this.metricMap.remove(metricKey);
                this.globalMetricKeys.remove(metricKey);
            }
        }
    }
}

