/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.notification.internal;

import com.swirlds.common.notification.DispatchMode;
import com.swirlds.common.notification.DispatchOrder;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.NoListenersAvailableException;
import com.swirlds.common.notification.NotificationResult;
import com.swirlds.common.notification.internal.AbstractNotificationEngine;
import com.swirlds.common.notification.internal.Dispatcher;
import com.swirlds.common.threading.manager.ThreadManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.hiero.base.concurrent.futures.StandardFuture;
import org.hiero.consensus.model.notification.Notification;

public class AsyncNotificationEngine
extends AbstractNotificationEngine {
    private final Map<Class<? extends Listener<?>>, Dispatcher<? extends Listener<?>>> listenerRegistry;
    private final ThreadManager threadManager;

    public AsyncNotificationEngine(ThreadManager threadManager) {
        this.threadManager = threadManager;
        this.listenerRegistry = new ConcurrentHashMap();
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
        for (Dispatcher<Listener<?>> dispatcher : this.listenerRegistry.values()) {
            if (!dispatcher.isRunning()) continue;
            dispatcher.stop();
        }
    }

    @Override
    public <L extends Listener<N>, N extends Notification> Future<NotificationResult<N>> dispatch(Class<L> listenerClass, N notification, StandardFuture.CompletionCallback<NotificationResult<N>> notificationsCompletedCallback) {
        this.checkArguments(listenerClass, (L)notification);
        DispatchOrder dispatchOrder = this.dispatchOrder(listenerClass);
        DispatchMode dispatchMode = this.dispatchMode(listenerClass);
        StandardFuture future = new StandardFuture(notificationsCompletedCallback);
        try {
            this.invokeWithDispatcher(dispatchOrder, listenerClass, dispatcher -> {
                this.assignSequence(notification);
                if (dispatchMode == DispatchMode.ASYNC) {
                    dispatcher.notifyAsync(notification, arg_0 -> ((StandardFuture)future).complete(arg_0));
                } else {
                    dispatcher.notifySync(notification, arg_0 -> ((StandardFuture)future).complete(arg_0));
                }
            });
        }
        catch (NoListenersAvailableException ex) {
            future.complete(new NotificationResult<N>(notification, 0));
        }
        return future;
    }

    @Override
    public <L extends Listener<?>> boolean register(Class<L> listenerClass, L callback) {
        AsyncNotificationEngine.checkArguments(listenerClass, callback);
        Dispatcher<L> dispatcher = this.ensureDispatcherExists(listenerClass);
        return dispatcher.addListener(callback);
    }

    @Override
    public <L extends Listener<?>> boolean unregister(Class<L> listenerClass, L callback) {
        AsyncNotificationEngine.checkArguments(listenerClass, callback);
        Dispatcher<L> dispatcher = this.ensureDispatcherExists(listenerClass);
        return dispatcher.removeListener(callback);
    }

    @Override
    public void unregisterAll() {
        this.listenerRegistry.clear();
    }

    private <L extends Listener<N>, N extends Notification> void checkArguments(Class<L> listenerClass, N notification) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification");
        }
    }

    private static <L extends Listener<?>> void checkArguments(Class<L> listenerClass, L callback) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
    }

    private <L extends Listener<?>> Dispatcher<L> ensureDispatcherExists(Class<L> listenerClass) {
        Dispatcher<L> dispatcher = this.listenerRegistry.putIfAbsent(listenerClass, new Dispatcher<L>(this.threadManager, listenerClass));
        if (dispatcher == null) {
            dispatcher = new Dispatcher<L>(this.threadManager, listenerClass);
            this.listenerRegistry.put(listenerClass, dispatcher);
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <L extends Listener<N>, N extends Notification> void invokeWithDispatcher(DispatchOrder order, Class<L> listenerClass, Consumer<Dispatcher<L>> method) throws NoListenersAvailableException {
        Dispatcher<Listener<?>> dispatcher = this.listenerRegistry.get(listenerClass);
        if (dispatcher == null) {
            throw new NoListenersAvailableException();
        }
        if (order == DispatchOrder.ORDERED) {
            Object object = dispatcher.getMutex();
            synchronized (object) {
                method.accept(dispatcher);
            }
        } else {
            method.accept(dispatcher);
        }
    }
}

